package jp.co.fujitsu.reffi.client.android.model;

import java.io.UnsupportedEncodingException;

import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.android.manager.SocketCoreManager;
import jp.co.fujitsu.reffi.client.android.util.ResultFormat;

public class SocketRecieveCore extends SocketCore {

	private int resultType = ResultFormat.BYTE_ARRAY;
	
	private String inputEncoding = "UTF-8";
	
	private byte[] rawResult;
	
	
	public int getResultType() {
		return resultType;
	}

	public void setResultType(int resultType) {
		this.resultType = resultType;
	}

	public String getInputEncoding() {
		return inputEncoding;
	}

	public void setInputEncoding(String inputEncoding) {
		this.inputEncoding = inputEncoding;
	}

	public byte[] getRawResult() {
		return rawResult;
	}

	public void setRawResult(byte[] rawResult) {
		this.rawResult = rawResult;
	}

	
	@Override
	protected void mainproc() throws Exception {
		SocketCoreManager manager = SocketCoreManager.getInstance();
		manager.connectToRecieve(this);
	}

	@Override
	protected void postproc() throws Exception {
		fireModelSuccess(new ModelProcessEvent(this));
	}

	
	public void onSocketAttached(SocketCoreManager manager) {
		postSocketAttached(manager);
	}
	
	protected void postSocketAttached(SocketCoreManager manager) {
	}
	
	public void onRecieve(byte[] data) throws 
		UnsupportedEncodingException, 
		XmlPullParserException, 
		JSONException 
	{
		setRawResult(data);
		
		Object result = 
			ResultFormat.convert(data,
								 getResultType(), 
								 getInputEncoding());
		
		postRecieve(result);
		
		ModelProcessEvent successEvent = new ModelProcessEvent(this);
		successEvent.setResult(result);
		fireModelSuccess(successEvent);
	}
	
	protected void postRecieve(Object result) {
	}
	
	public void onSocketClosed(SocketCoreManager manager) {
		postSocketClosed(manager);
		
		fireModelFinished(new ModelProcessEvent(this));
	}
	
	protected void postSocketClosed(SocketCoreManager manager) {
	}
}
