package jp.co.fujitsu.reffi.client.android.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.android.util.ResultFormat;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

public class HttpRequestCore extends BaseModel {

	public static final String GET = "GET";

	public static final String POST = "POST";

	

	private String uri;

	private String method = POST;

	private List<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();

	private int resultType = ResultFormat.BYTE_ARRAY;

	private int statusCode;
	
	private int responseSize;
	
	private String inputEncoding = "UTF-8";
	
	private String outputEncoding = "UTF-8";
	
	private byte[] rawResult;
	
	
	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public List<BasicNameValuePair> getParameters() {
		return parameters;
	}

	public void setParameters(List<BasicNameValuePair> parameters) {
		this.parameters = parameters;
	}

	public int getResultType() {
		return resultType;
	}

	public void setResultType(int resultType) {
		this.resultType = resultType;
	}

	public void addParameters(String key, String value) {
		BasicNameValuePair pair = new BasicNameValuePair(key, value);
		this.parameters.add(pair);
	}
	
	public int getStatusCode() {
		return statusCode;
	}

	public void setStatusCode(int statusCode) {
		this.statusCode = statusCode;
	}

	public int getResponseSize() {
		return responseSize;
	}

	public void setResponseSize(int responseSize) {
		this.responseSize = responseSize;
	}
	
	public String getInputEncoding() {
		return inputEncoding;
	}

	public void setInputEncoding(String inputEncoding) {
		this.inputEncoding = inputEncoding;
	}

	public String getOutputEncoding() {
		return outputEncoding;
	}

	public void setOutputEncoding(String outputEncoding) {
		this.outputEncoding = outputEncoding;
	}

	public byte[] getRawResult() {
		return rawResult;
	}

	public void setRawResult(byte[] rawResult) {
		this.rawResult = rawResult;
	}


	@Override
	protected void mainproc() throws Exception {

		HttpRequestBase request = null;
		
		if(method.equals(POST)) {
			request = new HttpPost(getUri());
			if(getParameters().size() > 0) {
				((HttpPost)request).setEntity(new UrlEncodedFormEntity(getParameters(), getOutputEncoding()));
			}
		}else if(method.equals(GET)) {
			String query = "";
			if(getParameters().size() > 0) {
				query = "?" + URLEncodedUtils.format(getParameters(), getOutputEncoding());
			}
			request = new HttpGet(getUri() + query);
		}

		preSend(request);
		
		byte[] buf = send(request);
		setRawResult(buf);
		setResponseSize(buf.length);

		Object result = ResultFormat.convert(buf, getResultType(), getInputEncoding());

		postSend(result);
		
		setResult(result);
	}

	@Override
	protected void postproc() throws Exception {
		ModelProcessEvent successEvent = new ModelProcessEvent(this);
		successEvent.setResult(getResult());
		
		fireModelSuccess(successEvent);
		fireModelFinished(new ModelProcessEvent(this));
	}

	
	protected void preSend(HttpRequestBase request) {
	}
	
	protected byte[] send(HttpRequestBase request) throws IOException, XmlPullParserException, JSONException {
		DefaultHttpClient client = new DefaultHttpClient();
		HttpResponse httpResponse = client.execute(request);

		int statusCode = httpResponse.getStatusLine().getStatusCode();
		setStatusCode(statusCode);

		int size;
		byte[] w = new byte[1024];
		HttpEntity entity = httpResponse.getEntity();
		InputStream in = entity.getContent();
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		while(true) {
			size = in.read(w);
			if (size <= 0) {
				break;
			}
			out.write(w, 0, size);
		}
		out.close();
		in.close();
		entity.consumeContent();
		request.abort();
		client.getConnectionManager().shutdown();

		byte[] buf = out.toByteArray();
		
		
		return buf;
	}
	
	protected void postSend(Object result) {
	}
}
