package jp.co.fujitsu.reffi.client.android.manager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import jp.co.fujitsu.reffi.client.android.model.SocketCore;
import jp.co.fujitsu.reffi.client.android.model.SocketRecieveCore;
import jp.co.fujitsu.reffi.client.android.util.ResultFormat;
import android.util.Log;


public class SocketCoreManager {
	
	private static SocketCoreManager instance = null;
	
	public static String SOCKET = "socket";
	
	public static String IN = "in";
	
	public static String OUT = "out";
	
	public static String RECIEVER = "RECIEVER";
	
	public static String SOCKET_RECIEVE_CORES = "SOCKET_RECIEVE_CORES";
	
	private Map<String, Map<String, Object>> socketMap = new HashMap<String, Map<String, Object>>();
	
	
	public static SocketCoreManager getInstance() {
		if(instance == null) {
			instance = new SocketCoreManager();
		}
		return instance;
	}
	
	private SocketCoreManager() {
	}
	
	public Map<String, Object> connect(SocketCore socketCore) throws IOException {
		String identifier = socketCore.getIp() + ":" + socketCore.getPort();
		
		Map<String, Object> socketInfo = socketMap.get(identifier);

		Socket socket = null;
		InputStream in = null;
		
		// 初接続のIP、PORTの場合
		if(socketInfo == null) {
			// Socket情報マップを新規追加
			socket = new Socket(socketCore.getIp(), socketCore.getPort());
			in = socket.getInputStream();
			OutputStream out = socket.getOutputStream();

			socketInfo = new HashMap<String, Object>();
			socketInfo.put(SOCKET, socket);
			socketInfo.put(IN, in);
			socketInfo.put(OUT, out);

			socketMap.put(identifier, socketInfo);
		}

		return socketInfo;
	}
	
	public Map<String, Object> connectToRecieve(SocketCore socketCore) throws IOException {
		Map<String, Object> socketInfo = connect(socketCore);

		SocketReciever reciever = (SocketReciever)socketInfo.get(RECIEVER);
		if(reciever == null) {
			reciever = new SocketReciever(socketInfo);
			ExecutorService executor = Executors.newCachedThreadPool();
			Future<Object> future = executor.submit(reciever);

			socketInfo.put(SOCKET_RECIEVE_CORES, new ArrayList<SocketRecieveCore>());
		}
		
		// Socket情報マップにManagerを使用したSocketRecieveCoreを保存
		// socket close時にクローズした旨を伝達する為
		List<SocketRecieveCore> recieveCores = 
			(List<SocketRecieveCore>)socketInfo.get(SOCKET_RECIEVE_CORES);
		recieveCores.add((SocketRecieveCore)socketCore);
		
		// Socketが新規接続、もしくは既存のSocketが使用可能になったことをSocketRecieveCoreに通知
		((SocketRecieveCore)socketCore).onSocketAttached(this);

		return socketInfo;
	}
	
	public boolean disconnect(SocketCore socketCore) throws IOException {
		return disconnect(socketCore.getIp(), socketCore.getPort());
	}
	
	public boolean disconnect(String ip, int port) throws IOException {
		String identifier = ip + ":" + port;

		Map<String, Object> socketInfo = socketMap.get(identifier);
		
		if(socketInfo == null) {
			return false;
		}
		
		Socket socket = (Socket)socketInfo.get(SOCKET);
		InputStream in = (InputStream)socketInfo.get(IN);
		OutputStream out = (OutputStream)socketInfo.get(OUT);
		in.close();
		out.close();
		socket.close();

		// SocketがcloseしたことをSocketRecieveCore群に通知
		List<SocketRecieveCore> recieveCores = 
			(List<SocketRecieveCore>)socketInfo.get(SOCKET_RECIEVE_CORES);
		for(SocketRecieveCore recieveCore : recieveCores) {
			recieveCore.onSocketClosed(this);
		}
		socketMap.remove(identifier);
		
		return true;
	}
	
	public Socket getSocket(String ip, int port) {
		Socket ret = null;
		
		Map<String, Object> socketInfo = socketMap.get(ip + ":" + port);
		if(socketInfo != null) {
			ret = (Socket)socketInfo.get(SOCKET);
		}		

		return ret;
	}
	
	public InputStream getInputStream(String ip, int port) {
		InputStream ret = null;
		
		Map<String, Object> socketInfo = socketMap.get(ip + ":" + port);
		if(socketInfo != null) {
			ret = (InputStream)socketInfo.get(IN);
		}		

		return ret;
	}
	
	public OutputStream getOutputStream(String ip, int port) {
		OutputStream ret = null;
		
		Map<String, Object> socketInfo = socketMap.get(ip + ":" + port);
		if(socketInfo != null) {
			ret = (OutputStream)socketInfo.get(OUT);
		}		

		return ret;
	}
	
	
	public class SocketReciever implements Callable<Object> {
		
		private Map<String, Object> socketInfo;
		
		public SocketReciever(Map<String, Object> socketInfo) {
			this.socketInfo = socketInfo;
		}
		
		public Object call() {
			int size;
			byte[] w = new byte[1024];
			try {
				Socket socket = (Socket)socketInfo.get(SOCKET);
				InputStream in = (InputStream)socketInfo.get(IN);
				
				while (socket != null && socket.isConnected()) {
					size = in.read(w);
					if (size <= 0)
						continue;
					ByteArrayOutputStream out = new ByteArrayOutputStream();
					out.write(w, 0, size);
					out.close();

					byte[] buf = out.toByteArray();
					
					List<SocketRecieveCore> reciveCores = 
						(List<SocketRecieveCore>)socketInfo.get(SOCKET_RECIEVE_CORES);
					for(SocketRecieveCore recieveCore : reciveCores) {
						recieveCore.onRecieve(buf);
					}
					
				}
			} catch (Exception e) {
				Log.d("", "connect fail.");
			}
			return null;
		}
	};


}
