package jp.co.fujitsu.reffi.client.android.controller.attachment;

import java.util.Calendar;

import android.widget.DatePicker;
import android.widget.DatePicker.OnDateChangedListener;

public class DatePickerListenerAttachment implements ListenerAttachment {

	@Override
	public void attachListener(Object target, Class<? extends Object> listenerType, Object listenerProxy) {
		if (listenerType == OnDateChangedListener.class) {
			Calendar calendar = Calendar.getInstance();
			int year = calendar.get(Calendar.YEAR);
			int month = calendar.get(Calendar.MONTH);
			int day = calendar.get(Calendar.DATE);
			
			((DatePicker) target).init(year, month, day, (OnDateChangedListener) listenerProxy);
		}
	}
}
