package jp.co.fujitsu.reffi.client.android.app;

import jp.co.fujitsu.reffi.client.android.controller.AbstractController;
import jp.co.fujitsu.reffi.client.android.listener.ActivityCallbackListener;
import android.accounts.AccountAuthenticatorActivity;
import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources.Theme;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ActionMode.Callback;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.ViewGroup.LayoutParams;

public abstract class BaseAccountAuthenticatorActivity extends AccountAuthenticatorActivity implements ActivityEnhancer {

	public ActivityCallbackDelegater delegater;
	
	public BaseAccountAuthenticatorActivity() {
		super();
		
		delegater = new ActivityCallbackDelegater(this);
		delegater.activityConstructed();
	}
	
	public AbstractController registController() {
		return null;
	}
	

	public abstract String registActivityName();
	
	public int registContentView() {
		return -1;
	}
	
	public void setActivityCallbackListener(ActivityCallbackListener listener) {
		delegater.setActivityCallbackListener(listener);
	}
	
	@Override
	public void addContentView(View view, LayoutParams params) {
		super.addContentView(view, params);
		
		delegater.addContentView(view, params);
	}

	@Override
	protected void attachBaseContext(Context newBase) {

		super.attachBaseContext(newBase);
		
		delegater.attachBaseContext(newBase);
	}
	
	@Override
	public void onActionModeFinished(ActionMode mode) {
	
		super.onActionModeFinished(mode);

		delegater.onActionModeFinished(mode);
	}

	@Override
	public void onActionModeStarted(ActionMode mode) {

		super.onActionModeStarted(mode);
		
		delegater.onActionModeStarted(mode);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		
		delegater.onActivityResult(requestCode, resultCode, data);
	}

	@Override
	protected void onApplyThemeResource(Theme theme, int resid, boolean first) {
		super.onApplyThemeResource(theme, resid, first);
		
		delegater.onApplyThemeResource(theme, resid, first);
	}

	@Override
	public void onAttachedToWindow() {
		super.onAttachedToWindow();
		
		delegater.onAttachedToWindow();
	}

	@Override
	public void onAttachFragment(Fragment fragment) {

		super.onAttachFragment(fragment);
		
		delegater.onAttachFragment(fragment);
	}

	@Override
	public void onBackPressed() {
		super.onBackPressed();
		
		delegater.onBackPressed();
	}

	@Override
	protected void onChildTitleChanged(Activity childActivity, CharSequence title) {
		super.onChildTitleChanged(childActivity, title);
		
		delegater.onChildTitleChanged(childActivity, title);
	}

	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		
		delegater.onConfigurationChanged(newConfig);
	}

	@Override
	public void onContentChanged() {
		super.onContentChanged();
		
		delegater.onContentChanged();
	}

	@Override
	public boolean onContextItemSelected(MenuItem item) {
		boolean ret = super.onContextItemSelected(item);
		
		delegater.onContextItemSelected(item);
		
		return ret;
	}

	@Override
	public void onContextMenuClosed(Menu menu) {
		super.onContextMenuClosed(menu);
		
		delegater.onContextMenuClosed(menu);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		delegater.onCreate(savedInstanceState);
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
		super.onCreateContextMenu(menu, v, menuInfo);
		
		delegater.onCreateContextMenu(menu, v, menuInfo);
	}

	@Override
	public CharSequence onCreateDescription() {
		CharSequence ret = super.onCreateDescription(); 
		
		delegater.onCreateDescription();
		
		return ret; 
	}

	@Override
	protected Dialog onCreateDialog(int id) {
		Dialog ret = super.onCreateDialog(id); 
		
		delegater.onCreateDialog(id);
		
		return ret; 
	}

	@Override
	protected Dialog onCreateDialog(int id, Bundle args) {
		delegater.onCreateDialog(id, args);

		return super.onCreateDialog(id, args);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		boolean ret = super.onCreateOptionsMenu(menu); 
		
		delegater.onCreateOptionsMenu(menu);
		
		return ret;
	}

	@Override
	public boolean onCreatePanelMenu(int featureId, Menu menu) {
		boolean ret = super.onCreatePanelMenu(featureId, menu);
		
		delegater.onCreatePanelMenu(featureId, menu);
		
		return ret; 
	}

	@Override
	public View onCreatePanelView(int featureId) {
		View ret = super.onCreatePanelView(featureId); 
		
		delegater.onCreatePanelView(featureId);
		
		return ret; 
	}

	@Override
	public boolean onCreateThumbnail(Bitmap outBitmap, Canvas canvas) {
		boolean ret = super.onCreateThumbnail(outBitmap, canvas); 
		
		delegater.onCreateThumbnail(outBitmap, canvas);
		
		return ret;
	}

	@Override
	public View onCreateView(String name, Context context, AttributeSet attrs) {
		View ret = super.onCreateView(name, context, attrs); 
		
		delegater.onCreateView(name, context, attrs);
		
		return ret; 
	}

	@Override
	public View onCreateView(View parent, String name, Context context,	AttributeSet attrs) {

		delegater.onCreateView(parent, name, context, attrs);
		
		return super.onCreateView(parent, name, context, attrs);
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		
		delegater.onDestroy();
	}

	@Override
	public void onDetachedFromWindow() {
		super.onDetachedFromWindow();
		
		delegater.onDetachedFromWindow();
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		boolean ret = super.onKeyDown(keyCode, event);
		
		delegater.onKeyDown(keyCode, event);
		
		return ret;
	}

	@Override
	public boolean onKeyLongPress(int keyCode, KeyEvent event) {
		boolean ret = super.onKeyLongPress(keyCode, event);
		
		delegater.onKeyLongPress(keyCode, event);
		
		return ret;
	}

	@Override
	public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
		boolean ret = super.onKeyMultiple(keyCode, repeatCount, event);
		
		delegater.onKeyMultiple(keyCode, repeatCount, event);
		
		return ret;
	}

	@Override
	public boolean onKeyShortcut(int keyCode, KeyEvent event) {

		delegater.onKeyShortcut(keyCode, event);

		return super.onKeyShortcut(keyCode, event);
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		boolean ret = super.onKeyUp(keyCode, event); 
		
		delegater.onKeyUp(keyCode, event);
		
		return ret; 
	}

	@Override
	public void onLowMemory() {
		super.onLowMemory();
		
		delegater.onLowMemory();
	}

	@Override
	public boolean onMenuItemSelected(int featureId, MenuItem item) {
		
		delegater.onMenuItemSelected(featureId, item);
		
		return super.onMenuItemSelected(featureId, item);
	}

	@Override
	public boolean onMenuOpened(int featureId, Menu menu) {
		delegater.onMenuOpened(featureId, menu);
		
		return super.onMenuOpened(featureId, menu);
	}

	@Override
	protected void onNewIntent(Intent intent) {
		
		delegater.onNewIntent(intent);
		super.onNewIntent(intent);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		
		delegater.onOptionsItemSelected(item);
		return super.onOptionsItemSelected(item);
	}

	@Override
	public void onOptionsMenuClosed(Menu menu) {
		
		super.onOptionsMenuClosed(menu);

		delegater.onOptionsMenuClosed(menu);
	}

	@Override
	public void onPanelClosed(int featureId, Menu menu) {
		super.onPanelClosed(featureId, menu);
		delegater.onPanelClosed(featureId, menu);
	}

	@Override
	protected void onPause() {
		
		super.onPause();
		
		delegater.onPause();
	}

	@Override
	protected void onPostCreate(Bundle savedInstanceState) {
		
		super.onPostCreate(savedInstanceState);
		delegater.onPostCreate(savedInstanceState);
		
	}

	@Override
	protected void onPostResume() {
		super.onPostResume();
		
		delegater.onPostResume();
	}

	@Override
	protected void onPrepareDialog(int id, Dialog dialog) {
		super.onPrepareDialog(id, dialog);
		
		delegater.onPrepareDialog(id, dialog);
	}

	@Override
	protected void onPrepareDialog(int id, Dialog dialog, Bundle args) {
		delegater.onPrepareDialog(id, dialog, args);

		super.onPrepareDialog(id, dialog, args);
	}

	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		
		delegater.onPrepareOptionsMenu(menu);
		
		return super.onPrepareOptionsMenu(menu);
	}

	@Override
	public boolean onPreparePanel(int featureId, View view, Menu menu) {
		
		delegater.onPreparePanel(featureId, view, menu);
		
		return super.onPreparePanel(featureId, view, menu);
	}

	@Override
	protected void onRestart() {
		super.onRestart();
		
		delegater.onRestart();
	}

	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);
		
		delegater.onRestoreInstanceState(savedInstanceState);
	}

	@Override
	protected void onResume() {
		super.onResume();
		
		delegater.onResume();
	}

	@Override
	public Object onRetainNonConfigurationInstance() {
		
		delegater.onRetainNonConfigurationInstance();
		
		return super.onRetainNonConfigurationInstance();
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		
		delegater.onSaveInstanceState(outState);
	}

	@Override
	public boolean onSearchRequested() {
		
		delegater.onSearchRequested();
		
		return super.onSearchRequested();
	}

	@Override
	protected void onStart() {
		super.onStart();
		
		delegater.onStart();
	}

	@Override
	protected void onStop() {
		super.onStop();
		
		delegater.onStop();
	}

	@Override
	protected void onTitleChanged(CharSequence title, int color) {
		super.onTitleChanged(title, color);
		
		delegater.onTitleChanged(title, color);
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		delegater.onTouchEvent(event);
		
		return super.onTouchEvent(event);
	}

	@Override
	public boolean onTrackballEvent(MotionEvent event) {
		
		delegater.onTrackballEvent(event);
		return super.onTrackballEvent(event);
	}

	@Override
	public void onUserInteraction() {
		super.onUserInteraction();
		
		delegater.onUserInteraction();
	}

	@Override
	protected void onUserLeaveHint() {
		super.onUserLeaveHint();
		
		delegater.onUserLeaveHint();
	}

	@Override
	public void onWindowAttributesChanged(android.view.WindowManager.LayoutParams params) {
		super.onWindowAttributesChanged(params);
		
		delegater.onWindowAttributesChanged(params);
	}

	@Override
	public void onWindowFocusChanged(boolean hasFocus) {
		super.onWindowFocusChanged(hasFocus);
		
		delegater.onWindowFocusChanged(hasFocus);
	}

	@Override
	public ActionMode onWindowStartingActionMode(Callback callback) {

		delegater.onWindowStartingActionMode(callback);

		return super.onWindowStartingActionMode(callback);
	}
	
}
