package jp.co.fujitsu.reffi.client.android.app;

import java.util.ArrayList;
import java.util.List;

import jp.co.fujitsu.reffi.client.android.controller.AbstractController;
import jp.co.fujitsu.reffi.client.android.controller.NamingRepository;
import jp.co.fujitsu.reffi.client.android.listener.ActivityCallbackListener;
import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources.Theme;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceScreen;
import android.preference.PreferenceActivity.Header;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.InflateException;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ActionMode.Callback;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.LayoutInflater.Factory;
import android.view.ViewGroup.LayoutParams;
import android.widget.ExpandableListView;
import android.widget.ListView;

public class ActivityCallbackDelegater {
	
	
	private Activity activity;
	
	
	private AbstractController controller;

	
	private List<ActivityCallbackListener> listenerList = new ArrayList<ActivityCallbackListener>();
	
	
	public Activity getActivity() {
		return activity;
	}

	
	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	
	public AbstractController getController() {
		return controller;
	}

	
	public void setController(AbstractController controller) {
		this.controller = controller;
	}

	
	public List<ActivityCallbackListener> getListenerList() {
		return listenerList;
	}

	
	public void setListenerList(List<ActivityCallbackListener> listenerList) {
		this.listenerList = listenerList;
	}
	
	
	/**
	 * 
	 * @param activity
	 */
	public ActivityCallbackDelegater(Activity activity) {
		this.activity = activity;
	}
	
	
	public void setActivityCallbackListener(ActivityCallbackListener listener) {
		this.listenerList.add(listener);
	}

	
	public void activityConstructed() {
		Log.d(activity.getClass().getSimpleName(), "Acitivity Constructed");
	}

	
	public void addContentView(View view, LayoutParams params) {
		Log.d(activity.getClass().getSimpleName(), "addContentView called");
	}

	
	protected void attachBaseContext(Context newBase) {
		Log.d(activity.getClass().getSimpleName(), "attachBaseContext called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.attachBaseContext(newBase);
		}
	}

	
	public void onActionModeFinished(ActionMode mode) {
		Log.d(activity.getClass().getSimpleName(), "onActionModeFinished called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onActionModeFinished(mode);
		}
	}

	
	public void onActionModeStarted(ActionMode mode) {
		Log.d(activity.getClass().getSimpleName(), "onActionModeStarted called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onActionModeStarted(mode);
		}
	}
	
	
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		Log.d(activity.getClass().getSimpleName(), "onActivityResult called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onActivityResult(requestCode, resultCode, data);
		}
	}

	
	protected void onApplyThemeResource(Theme theme, int resid, boolean first) {
		Log.d(activity.getClass().getSimpleName(), "onApplyThemeResource called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onApplyThemeResource(theme, resid, first);
		}
	}

	
	public void onAttachedToWindow() {
		Log.d(activity.getClass().getSimpleName(), "onAttachedToWindow called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onAttachedToWindow();
		}
	}

	
	public void onAttachFragment(Fragment fragment) {
		Log.d(activity.getClass().getSimpleName(), "onAttachFragment called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onAttachFragment(fragment);
		}
	}

	
	public void onBackPressed() {
		Log.d(activity.getClass().getSimpleName(), "onBackPressed called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onBackPressed();
		}
	}

	
	public void onBuildHeaders(List<Header> target) {
		Log.d(activity.getClass().getSimpleName(), "onBuildHeaders called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onBuildHeaders(target);
		}
	}

	
	public boolean onChildClick(ExpandableListView parent, View v,
			int groupPosition, int childPosition, long id) {
		Log.d(activity.getClass().getSimpleName(), "onChildClick called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onChildClick(parent, v, groupPosition, childPosition, id);
		}
		return false;
	}

	
	protected void onChildTitleChanged(Activity childActivity, CharSequence title) {
		Log.d(activity.getClass().getSimpleName(), "onChildTitleChanged called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onChildTitleChanged(childActivity, title);
		}
	}
	
	
	public void onConfigurationChanged(Configuration newConfig) {
		Log.d(activity.getClass().getSimpleName(), "onConfigurationChanged called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onConfigurationChanged(newConfig);
		}
	}

	
	public void onContentChanged() {
		Log.d(activity.getClass().getSimpleName(), "onContentChanged called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onContentChanged();
		}
	}

	
	public boolean onContextItemSelected(MenuItem item) {
		Log.d(activity.getClass().getSimpleName(), "onContextItemSelected called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onContextItemSelected(item);
		}
		return false;
	}

	
	public void onContextMenuClosed(Menu menu) {
		Log.d(activity.getClass().getSimpleName(), "onContextMenuClosed called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onContextMenuClosed(menu);
		}
	}

	
	protected void onCreate(Bundle savedInstanceState) {
		Log.d(activity.getClass().getSimpleName(), "onCreate called");
		
		this.controller = (AbstractController)this.activity.getApplication();
		NamingRepository.put(activity, activity, ((ActivityEnhancer)activity).registActivityName());
		Log.d("Naming", NamingRepository.repository.toString());
		this.controller.bindEvents(getActivity(), getActivity());


		final LayoutInflater inflator = activity.getLayoutInflater();
		inflator.setFactory(new Factory() {
			
			public View onCreateView(String name, Context context, AttributeSet attrs) {
				Log.d("name", name);

				LayoutInflater inflater = LayoutInflater.from(activity);
				View view = null;
				
				if(name.startsWith("com.android.internal")) {
					return null;
				}
				if(name.contains(".")) {
					try{
						view = inflater.createView(name, null, attrs);
					}catch(ClassNotFoundException e) {
						Log.e("err", activity.getClass().getSimpleName(), e);
					}
				}else{
					String[] prefixes = new String[]{"android.widget.", "android.webkit.", "android.view."};
					for(String prefix : prefixes) {
						try{
							view = inflater.createView(name, prefix, attrs);
							if(view != null) break;
						}catch(InflateException e) {
							Log.e("err", activity.getClass().getSimpleName(), e);
						}catch(ClassNotFoundException e) {
							Log.e("err", activity.getClass().getSimpleName(), e);
						}
					}
				}
				if(view == null) return null;
				Log.d(activity.getClass().getSimpleName(), view.getClass().getSimpleName());

				String viewName = attrs.getAttributeValue(null, "name");
				
				if(viewName != null) {
					Log.d("viewName", viewName);
					NamingRepository.put(getActivity(), view, viewName);
				}
					
				controller.bindEvents(getActivity(), view);
				return view;
			}
		});

		int contentViewId = ((ActivityEnhancer)activity).registContentView();
		if(contentViewId != -1) {
			activity.setContentView(contentViewId);
		}

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreate(savedInstanceState);
		}
	}

	
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
		Log.d(activity.getClass().getSimpleName(), "onCreateContextMenu called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreateContextMenu(menu, v, menuInfo);
		}
	}

	
	public CharSequence onCreateDescription() {
		Log.d(activity.getClass().getSimpleName(), "onCreateDescription called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreateDescription();
		}
		return null;
	}

	
	protected Dialog onCreateDialog(int id) {
		Log.d(activity.getClass().getSimpleName(), "onCreateDialog called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreateDialog(id);
		}
		return null;
	}

	
	protected Dialog onCreateDialog(int id, Bundle args) {
		Log.d(activity.getClass().getSimpleName(), "onCreateDialog called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreateDialog(id, args);
		}
		return null;
	}
	
	
	public boolean onCreateOptionsMenu(Menu menu) {
		Log.d(activity.getClass().getSimpleName(), "onCreateOptionsMenu called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreateOptionsMenu(menu);
		}
//		return false;
		return true;
	}

	
	public boolean onCreatePanelMenu(int featureId, Menu menu) {
		Log.d(activity.getClass().getSimpleName(), "onCreatePanelMenu called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreatePanelMenu(featureId, menu);
		}
		return false;
	}

	
	public View onCreatePanelView(int featureId) {
		Log.d(activity.getClass().getSimpleName(), "onCreatePanelView called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreatePanelView(featureId);
		}

		return null;
	}

	
	public boolean onCreateThumbnail(Bitmap outBitmap, Canvas canvas) {
		Log.d(activity.getClass().getSimpleName(), "onCreateThumbnail called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreateThumbnail(outBitmap, canvas);
		}
		return false;
	}

	
	public View onCreateView(String name, Context context, AttributeSet attrs) {
		Log.d(activity.getClass().getSimpleName(), "onCreateView called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreateView(name, context, attrs);
		}
		return null;
	}

	
	public View onCreateView(View parent, String name, Context context,	AttributeSet attrs) {
		Log.d(activity.getClass().getSimpleName(), "onCreateView called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onCreateView(parent, name, context, attrs);
		}
		return null;
	}

	
	protected void onDestroy() {
		Log.d(activity.getClass().getSimpleName(), "onDestroy called");
		
		NamingRepository.remove(getActivity());
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onDestroy();
		}
	}


	public void onDetachedFromWindow() {
		Log.d(activity.getClass().getSimpleName(), "onDetachedFromWindow called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onDetachedFromWindow();
		}
	}

	
	public Header onGetInitialHeader() {
		Log.d(activity.getClass().getSimpleName(), "onGetInitialHeader called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onGetInitialHeader();
		}
		return null;
	}


	public Header onGetNewHeader() {
		Log.d(activity.getClass().getSimpleName(), "onGetNewHeader called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onGetNewHeader();
		}
		return null;
	}


	public void onGlobalLayout() {
		Log.d(activity.getClass().getSimpleName(), "onGlobalLayout called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onGlobalLayout();
		}
	}

	
	public void onGroupCollapse(int groupPosition) {
		Log.d(activity.getClass().getSimpleName(), "onGroupCollapse called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onGroupCollapse(groupPosition);
		}
	}

	
	public void onGroupExpand(int groupPosition) {
		Log.d(activity.getClass().getSimpleName(), "onGroupExpand called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onGroupExpand(groupPosition);
		}
	}

	
	public void onHeaderClick(Header header, int position) {
		Log.d(activity.getClass().getSimpleName(), "onHeaderClick called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onHeaderClick(header, position);
		}
	}


	public void onInputQueueCreated(InputQueue queue) {
		Log.d(activity.getClass().getSimpleName(), "onInputQueueCreated called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onInputQueueCreated(queue);
		}
	}


	public void onInputQueueDestroyed(InputQueue queue) {
		Log.d(activity.getClass().getSimpleName(), "onInputQueueDestroyed called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onInputQueueDestroyed(queue);
		}
	}


	public boolean onIsHidingHeaders() {
		Log.d(activity.getClass().getSimpleName(), "onIsHidingHeaders called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onIsHidingHeaders();
		}
		return false;
	}


	public boolean onIsMultiPane() {
		Log.d(activity.getClass().getSimpleName(), "onIsMultiPane called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onIsMultiPane();
		}
		return false;
	}


	public boolean onKeyDown(int keyCode, KeyEvent event) {
		Log.d(activity.getClass().getSimpleName(), "onKeyDown called");

		for(ActivityCallbackListener listener : this.listenerList) {
//			listener.onKeyDown(keyCode, event);
		}
		return false;
	}

	
	public boolean onKeyLongPress(int keyCode, KeyEvent event) {
		Log.d(activity.getClass().getSimpleName(), "onKeyLongPress called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onKeyLongPress(keyCode, event);
		}
		return false;
	}

	
	public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
		Log.d(activity.getClass().getSimpleName(), "onKeyMultiple called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onKeyMultiple(keyCode, repeatCount, event);
		}
		return false;
	}

	
	public boolean onKeyShortcut(int keyCode, KeyEvent event) {
		Log.d(activity.getClass().getSimpleName(), "onKeyShortcut called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onKeyShortcut(keyCode, event);
		}
		return false;
	}

	
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		Log.d(activity.getClass().getSimpleName(), "onKeyUp called");

		for(ActivityCallbackListener listener : this.listenerList) {
//			listener.onKeyUp(keyCode, event);
		}
		return false;
	}

	
	protected void onListItemClick(ListView l, View v, int position, long id) {
		Log.d(activity.getClass().getSimpleName(), "onListItemClick called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onListItemClick(l, v, position, id);
		}
	}

	
	public void onLowMemory() {
		Log.d(activity.getClass().getSimpleName(), "onLowMemory called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onLowMemory();
		}
	}

	
	public boolean onMenuItemSelected(int featureId, MenuItem item) {
		Log.d(activity.getClass().getSimpleName(), "onMenuItemSelected called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onMenuItemSelected(featureId, item);
		}
		return false;
	}

	
	public boolean onMenuOpened(int featureId, Menu menu) {
		Log.d(activity.getClass().getSimpleName(), "onMenuOpened called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onMenuOpened(featureId, menu);
		}
//		return false;
		return true;
	}

	
	protected void onNewIntent(Intent intent) {
		Log.d(activity.getClass().getSimpleName(), "onNewIntent called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onNewIntent(intent);
		}
	}

	
	public boolean onOptionsItemSelected(MenuItem item) {
		Log.d(activity.getClass().getSimpleName(), "onOptionsItemSelected called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onOptionsItemSelected(item);
		}
//		return false;
		return true;
	}

	
	public void onOptionsMenuClosed(Menu menu) {
		Log.d(activity.getClass().getSimpleName(), "onOptionsMenuClosed called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onOptionsMenuClosed(menu);
		}
	}
	
	public void onPanelClosed(int featureId, Menu menu) {
		Log.d(activity.getClass().getSimpleName(), "onPanelClosed called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPanelClosed(featureId, menu);
		}
	}

	
	protected void onPause() {
		Log.d(activity.getClass().getSimpleName(), "onPause called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPause();
		}
	}

	
	protected void onPostCreate(Bundle savedInstanceState) {
		Log.d(activity.getClass().getSimpleName(), "onPostCreate called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPostCreate(savedInstanceState);
		}
	}

	
	protected void onPostResume() {
		Log.d(activity.getClass().getSimpleName(), "onPostResume called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPostResume();
		}
	}

	
	public boolean onPreferenceStartFragment(PreferenceFragment caller,	Preference pref) {
		Log.d(activity.getClass().getSimpleName(), "onPreferenceStartFragment called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPreferenceStartFragment(caller, pref);
		}
		return false;
	}
	
	
	public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen,	Preference preference) {
		Log.d(activity.getClass().getSimpleName(), "onPreferenceTreeClick called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPreferenceTreeClick(preferenceScreen, preference);
		}
		return false;
	}

	
	protected void onPrepareDialog(int id, Dialog dialog) {
		Log.d(activity.getClass().getSimpleName(), "onPrepareDialog called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPrepareDialog(id, dialog);
		}
	}

	
	protected void onPrepareDialog(int id, Dialog dialog, Bundle args) {
		Log.d(activity.getClass().getSimpleName(), "onPrepareDialog called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPrepareDialog(id, dialog, args);
		}
	}
	
	
	public boolean onPrepareOptionsMenu(Menu menu) {
		Log.d(activity.getClass().getSimpleName(), "onPrepareOptionsMenu called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPrepareOptionsMenu(menu);
		}
//		return false;
		return true;
	}

	
	public boolean onPreparePanel(int featureId, View view, Menu menu) {
		Log.d(activity.getClass().getSimpleName(), "onPreparePanel called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onPreparePanel(featureId, view, menu);
		}
		return false;
	}

	
	protected List<ResolveInfo> onQueryPackageManager(Intent queryIntent) {
		Log.d(activity.getClass().getSimpleName(), "onQueryPackageManager called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onQueryPackageManager(queryIntent);
		}
		return null;
	}

	
	protected void onRestart() {
		Log.d(activity.getClass().getSimpleName(), "onRestart called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onRestart();
		}
	}

	
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		Log.d(activity.getClass().getSimpleName(), "onRestoreInstanceState called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onRestoreInstanceState(savedInstanceState);
		}
	}

	
	protected void onResume() {
		Log.d(activity.getClass().getSimpleName(), "onResume called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onResume();
		}
	}

	
	public Object onRetainNonConfigurationInstance() {
		Log.d(activity.getClass().getSimpleName(), "onRetainNonConfigurationInstance called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onRetainNonConfigurationInstance();
		}
		return null;
	}

	
	protected void onSaveInstanceState(Bundle outState) {
		Log.d(activity.getClass().getSimpleName(), "onSaveInstanceState called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onSaveInstanceState(outState);
		}
	}

	
	public boolean onSearchRequested() {
		Log.d(activity.getClass().getSimpleName(), "onSearchRequested called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onSearchRequested();
		}
		return false;
	}

	
	protected void onSetContentView() {
		Log.d(activity.getClass().getSimpleName(), "onSetContentView called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onSetContentView();
		}
	}

	
	protected void onStart() {
		Log.d(activity.getClass().getSimpleName(), "onStart called");

		getController().setFrontActivity(getActivity());
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onStart();
		}
	}

	
	protected void onStop() {
		Log.d(activity.getClass().getSimpleName(), "onStop called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onStop();
		}
	}

	
	protected void onTitleChanged(CharSequence title, int color) {
		Log.d(activity.getClass().getSimpleName(), "onTitleChanged called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onTitleChanged(title, color);
		}
	}

	
	public boolean onTouchEvent(MotionEvent event) {
		Log.d(activity.getClass().getSimpleName(), "onTouchEvent called");
		
		Log.d("bbb", String.valueOf(this.listenerList.size()));
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onTouchEvent(event);
		}
		return false;
	}

	
	public boolean onTrackballEvent(MotionEvent event) {
		Log.d(activity.getClass().getSimpleName(), "onTrackballEvent called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onTrackballEvent(event);
		}
		return false;
	}

	
	public void onUserInteraction() {
		Log.d(activity.getClass().getSimpleName(), "onUserInteraction called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onUserInteraction();
		}
	}

	
	protected void onUserLeaveHint() {
		Log.d(activity.getClass().getSimpleName(), "onUserLeaveHint called");

		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onUserLeaveHint();
		}
	}

	
	public void onWindowAttributesChanged(android.view.WindowManager.LayoutParams params) {
		Log.d(activity.getClass().getSimpleName(), "onWindowAttributesChanged called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onWindowAttributesChanged(params);
		}
	}

	
	public void onWindowFocusChanged(boolean hasFocus) {
		Log.d(activity.getClass().getSimpleName(), "onWindowFocusChanged called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onWindowFocusChanged(hasFocus);
		}
	}

	
	public ActionMode onWindowStartingActionMode(Callback callback) {
		Log.d(activity.getClass().getSimpleName(), "onWindowStartingActionMode called");
		
		for(ActivityCallbackListener listener : this.listenerList) {
			listener.onWindowStartingActionMode(callback);
		}
		return null;
	}


}
