/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.flex.manager;

import flex.messaging.MessageBroker;
import flex.messaging.MessageDestination;
import flex.messaging.services.MessageService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum MessageManager {
    instance;

    public static final String DEFAULT_SERVICE_ID = "message-service";
    private static final Log LOG;

    public void start(String destination) {
        this.start(destination, DEFAULT_SERVICE_ID);
    }

    public void start(String destination, String serviceId) {
        if (this.exists(destination, serviceId)) {
            LOG.warn((Object)("destination exists (" + destination + ", " + serviceId + ")"));
            return;
        }
        MessageService messageService = this.getMessageService(serviceId);
        MessageDestination messageDestination = (MessageDestination)messageService.createDestination(destination);
        if (messageService.isStarted()) {
            messageDestination.start();
            LOG.info((Object)("destination started (" + destination + ", " + serviceId + ")"));
        } else {
            LOG.warn((Object)("destination not started (" + destination + ", " + serviceId + ")"));
        }
    }

    public void stop(String destination) {
        this.stop(destination, DEFAULT_SERVICE_ID);
    }

    public void stop(String destination, String serviceId) {
        if (!this.exists(destination, serviceId)) {
            LOG.warn((Object)("destination not exists (" + destination + ", " + serviceId + ")"));
            return;
        }
        MessageService messageService = this.getMessageService(serviceId);
        MessageDestination messageDestination = (MessageDestination)messageService.getDestination(destination);
        if (messageDestination.isStarted()) {
            messageDestination.stop();
            LOG.info((Object)("destination stopped (" + destination + ", " + serviceId + ")"));
        } else {
            LOG.warn((Object)("destination not stopped (" + destination + ", " + serviceId + ")"));
        }
    }

    public void stopAndRemove(String destination) {
        this.stopAndRemove(destination, DEFAULT_SERVICE_ID);
    }

    public void stopAndRemove(String destination, String serviceId) {
        this.stop(destination, serviceId);
        MessageService messageService = this.getMessageService(serviceId);
        messageService.removeDestination(destination);
    }

    public boolean exists(String destination) {
        return this.exists(destination, DEFAULT_SERVICE_ID);
    }

    public boolean exists(String destination, String serviceId) {
        MessageService messageService = this.getMessageService(serviceId);
        return messageService.getDestination(destination) != null;
    }

    private MessageService getMessageService(String serviceId) {
        MessageBroker messageBroker = MessageBroker.getMessageBroker(null);
        if (messageBroker == null) {
            return null;
        }
        return (MessageService)messageBroker.getService(serviceId);
    }

    static {
        LOG = LogFactory.getLog(MessageManager.class);
    }
}

