/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.model;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.co.fujitsu.reffi.client.swing.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.swing.model.BaseModel;

public class JMSPublishCore
extends BaseModel {
    private Hashtable<String, String> environment;
    private String connectionFactoryName = "ConnectionFactory";
    private TopicConnection topicConnection;
    private TopicSession topicSession;
    private Topic topic;
    private String topicName;
    private TopicPublisher publisher;
    private String textMessage;
    private Message message;

    public Hashtable<String, String> getEnvironment() {
        if (this.environment == null) {
            this.environment = this.getController().getClientConfig().getDefaultJmsEnvironment();
        }
        return this.environment;
    }

    public void setEnvironment(Hashtable<String, String> environment) {
        this.environment = environment;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public TopicConnection getTopicConnection() {
        return this.topicConnection;
    }

    public void setTopicConnection(TopicConnection topicConnection) {
        this.topicConnection = topicConnection;
    }

    public TopicSession getTopicSession() {
        return this.topicSession;
    }

    public void setTopicSession(TopicSession topicSession) {
        this.topicSession = topicSession;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public TopicPublisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(TopicPublisher publisher) {
        this.publisher = publisher;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public void setTextMessage(String textMessage) {
        this.textMessage = textMessage;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void createSession() throws NamingException, JMSException {
        InitialContext context = new InitialContext(this.getEnvironment());
        TopicConnectionFactory tcf = (TopicConnectionFactory)context.lookup(this.getConnectionFactoryName());
        this.setTopicConnection(tcf.createTopicConnection());
        this.setTopic((Topic)context.lookup(this.getTopicName()));
        this.setTopicSession(this.getTopicConnection().createTopicSession(false, 1));
    }

    @Override
    protected void mainproc() throws JMSException {
        this.getTopicConnection().start();
        this.setPublisher(this.getTopicSession().createPublisher(this.getTopic()));
        if (this.getTextMessage() != null) {
            this.setMessage((Message)this.getTopicSession().createTextMessage(this.getTextMessage()));
        }
        this.getPublisher().publish(this.getMessage());
    }

    @Override
    protected void postproc() throws Exception {
        ModelProcessEvent successEvent = new ModelProcessEvent(this);
        successEvent.setResult(this.getResult());
        this.fireModelSuccess(successEvent);
        this.fireModelFinished(new ModelProcessEvent(this));
    }

    @Override
    public void done() throws Exception {
        this.stop();
    }

    public void stop() throws JMSException {
        this.getPublisher().close();
        this.getTopicConnection().stop();
        this.getTopicSession().close();
        this.getTopicConnection().close();
    }

    public TextMessage createTextMessage() throws JMSException {
        TextMessage msg = this.getTopicSession().createTextMessage();
        return msg;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage msg = this.getTopicSession().createObjectMessage();
        return msg;
    }

    public MapMessage createMapMessage() throws JMSException {
        MapMessage msg = this.getTopicSession().createMapMessage();
        return msg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        StreamMessage msg = this.getTopicSession().createStreamMessage();
        return msg;
    }
}

