/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.model;

import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.PasswordAuthentication;
import java.util.List;
import jp.co.fujitsu.reffi.client.swing.model.BaseModel;

public abstract class AbstractHTTPCore
extends BaseModel {
    private String authUser;
    private char[] authPassword;
    private static CookieManager cookieManager = new CookieManager();
    private boolean sendCookie = true;

    public String getAuthUser() {
        return this.authUser;
    }

    public char[] getAuthPassword() {
        return this.authPassword;
    }

    public boolean isSendCookie() {
        return this.sendCookie;
    }

    public void setSendCookie(boolean sendCookie) {
        this.sendCookie = sendCookie;
    }

    public void setAuthentication(String user, char[] password) {
        this.authUser = user;
        this.authPassword = password;
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                PasswordAuthentication pa = null;
                try {
                    pa = new PasswordAuthentication(AbstractHTTPCore.this.authUser, AbstractHTTPCore.this.authPassword);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return pa;
            }
        });
    }

    public void removeAuthentication() {
        this.authUser = null;
        this.authPassword = null;
        Authenticator.setDefault(null);
    }

    protected String createCookieString() {
        StringBuilder ret = new StringBuilder("");
        List<HttpCookie> cookies = cookieManager.getCookieStore().getCookies();
        for (HttpCookie cookie : cookies) {
            String name = cookie.getName();
            String value = cookie.getValue();
            ret.append(name + "=" + value + ";");
        }
        return ret.toString();
    }

    static {
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }
}

