/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.co.fujitsu.reffi.client.swing.model.JMSSubscribeCore;

public class JMSSubscribeCoreManager {
    private static JMSSubscribeCoreManager instance;
    private Map<String, List<JMSSubscribeCore>> subscriberMap = new HashMap<String, List<JMSSubscribeCore>>();

    public Map<String, List<JMSSubscribeCore>> getSubscriberMap() {
        return this.subscriberMap;
    }

    public void setSubscriberMap(Map<String, List<JMSSubscribeCore>> subscriberMap) {
        this.subscriberMap = subscriberMap;
    }

    public static JMSSubscribeCoreManager getInstance() {
        if (instance == null) {
            instance = new JMSSubscribeCoreManager();
        }
        return instance;
    }

    private JMSSubscribeCoreManager() {
    }

    public void subscribe(String topicName, JMSSubscribeCore subscribeCore) throws NamingException, JMSException {
        List<Object> subscribeCoreList = null;
        InitialContext context = new InitialContext(subscribeCore.getEnvironment());
        TopicConnectionFactory tcf = (TopicConnectionFactory)context.lookup(subscribeCore.getConnectionFactoryName());
        TopicConnection topicConnection = tcf.createTopicConnection();
        if (subscribeCore.getClientId() != null) {
            topicConnection.setClientID(subscribeCore.getClientId());
        }
        subscribeCore.setTopicConnection(topicConnection);
        TopicSession topicSession = topicConnection.createTopicSession(false, 1);
        subscribeCore.setTopicSession(topicSession);
        Topic topic = (Topic)context.lookup(topicName);
        subscribeCore.setTopic(topic);
        TopicSubscriber subscriber = null;
        subscriber = subscribeCore.isDurable() ? topicSession.createDurableSubscriber(topic, subscribeCore.getDurableSubscriberName()) : topicSession.createSubscriber(topic);
        subscribeCore.setSubscriber(subscriber);
        subscriber.setMessageListener((MessageListener)subscribeCore);
        if (!this.getSubscriberMap().containsKey(topicName)) {
            subscribeCoreList = new ArrayList();
            this.getSubscriberMap().put(topicName, subscribeCoreList);
        } else {
            subscribeCoreList = this.getSubscriberMap().get(topicName);
        }
        subscribeCoreList.add(subscribeCore);
        topicConnection.start();
    }

    public void unsubscribe(String topicName) throws JMSException {
        this.unsubscribe(topicName, null);
    }

    public void unsubscribe(String topicName, String identifier) throws JMSException {
        Map<String, List<JMSSubscribeCore>> subscriberMap = this.getSubscriberMap();
        if (!subscriberMap.containsKey(topicName)) {
            return;
        }
        List<JMSSubscribeCore> subscribeCoreList = subscriberMap.get(topicName);
        if (identifier == null) {
            Iterator<JMSSubscribeCore> it = subscribeCoreList.iterator();
            while (it.hasNext()) {
                JMSSubscribeCore subscribeCore = it.next();
                this.stop(subscribeCore);
                it.remove();
            }
        } else {
            Iterator<JMSSubscribeCore> it = subscribeCoreList.iterator();
            while (it.hasNext()) {
                JMSSubscribeCore subscribeCore = it.next();
                if (!identifier.equals(subscribeCore.getIdentifier())) continue;
                this.stop(subscribeCore);
                it.remove();
            }
        }
        if (subscribeCoreList.size() == 0) {
            subscriberMap.remove(topicName);
        }
    }

    protected void stop(JMSSubscribeCore subscribeCore) throws JMSException {
        subscribeCore.onUnsubscribe();
        subscribeCore.getSubscriber().close();
        subscribeCore.getTopicConnection().stop();
        if (subscribeCore.isDurable()) {
            subscribeCore.getTopicSession().unsubscribe(subscribeCore.getDurableSubscriberName());
        }
        subscribeCore.getTopicSession().close();
        subscribeCore.getTopicConnection().close();
    }
}

