/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.helper;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import jp.co.fujitsu.reffi.client.swing.action.AbstractAction;
import jp.co.fujitsu.reffi.client.swing.action.BaseAction;
import jp.co.fujitsu.reffi.client.swing.controller.BaseController;
import jp.co.fujitsu.reffi.client.swing.controller.EventBinder;
import jp.co.fujitsu.reffi.client.swing.helper.ClassNode;
import jp.co.fujitsu.reffi.client.swing.manager.WindowManager;
import jp.co.fujitsu.reffi.client.swing.util.ComponentSearchUtil;

public class CorrelationBuilder {
    public static ClassNode build(BaseController controller) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        ClassNode controllerNode = new ClassNode(0, controller.getClass().getPackage().toString(), controller.getClass().getSimpleName());
        EventBinder eventBinder = controller.getEventBinder();
        List<Window> windowList = WindowManager.getInstance().getWindowList();
        for (Window window : windowList) {
            ClassNode viewNode = new ClassNode(1, window.getClass().getPackage().toString(), window.getClass().getSimpleName());
            controllerNode.addChild(viewNode);
            ArrayList<Component> componentList = new ArrayList<Component>();
            ComponentSearchUtil.searchComponentsByName(componentList, window, "*");
            for (Component c : componentList) {
                String componentName = c.getName();
                if (componentName == null || componentName.length() == 0 || !eventBinder.isEventBinding(componentName)) continue;
                List<Class<? extends EventListener>> listenerTypes = eventBinder.getListenerTypes(componentName);
                for (Class<? extends EventListener> listenerType : listenerTypes) {
                    List<String> eventTypes = eventBinder.getEventTypes(componentName, listenerType);
                    for (String eventType : eventTypes) {
                        Class<? extends AbstractAction> actionClass = eventBinder.getActionClass(componentName, listenerType, eventType);
                        ClassNode actionNode = new ClassNode(2, actionClass.getPackage().toString(), actionClass.getSimpleName());
                        viewNode.addChild(actionNode);
                        AbstractAction action = actionClass.newInstance();
                        Method method = BaseAction.class.getDeclaredMethod("reserveModels", List.class);
                        method.setAccessible(true);
                        ArrayList models = new ArrayList();
                        method.invoke((Object)action, models);
                        for (Class modelClass : models) {
                            ClassNode modelNode = new ClassNode(3, modelClass.getPackage().toString(), modelClass.getSimpleName());
                            actionNode.addChild(modelNode);
                        }
                    }
                }
            }
        }
        return controllerNode;
    }
}

