/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.validator {
	
	/**
	 * <p>[概 要] </p>
	 * ValidateErrorオブジェクトを集約するクラスです.
	 * 
	 * <p>[詳 細] </p>
	 * ValidateErrorオブジェクトを集約する為の配列「errors」プロパティを持ちます。<br />
	 * そのプロパティを対象に、
	 * <ul>
	 *     <li>エラー発生有無返却</li>
	 *     <li>エラー数返却</li>
	 *     <li>エラーエレメント判定</li>
	 *     <li>エラー集約への追加</li>
	 * </ul>
	 * 等の操作を行います。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi 
	 */
	public class ValidateErrors {
		
		// ValidationErrorを集約する配列
		private var _errors:Array = new Array();
		
		/**
		 * <p>[概 要]</p>
		 * ValidationErrorを集約する配列です.
		 * 
		 * <p>[詳 細]</p>
		 * 1バリデーションエラー情報を保持する
		 * ValidationErrorオブジェクトの配列です。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get errors():Array {
			return this._errors;
		}
		public function set errors(errors:Array):void {
			this._errors = errors;
		}
		
		/**
		 * <p>[概 要] </p>
		 * バリデーションエラーが有ったかどうかを判定します.
		 * 
		 * <p>[詳 細] </p>
		 * errorsフィールドのサイズを判定し、0以上であればtrueを返却します。
		 * 
		 * <p>[備 考] </p>
		 * 
		 * @return true : エラー有り、 false : エラー無し
		 */
		public function hasError():Boolean {
			return errors.length > 0 ? true : false;
		}
		
		/**
		 * <p>[概 要] </p>
		 * バリデーションエラーの数を返却します.
		 * 
		 * <p>[詳 細] </p>
		 * errorsフィールドのサイズを返却します。
		 * 
		 * <p>[備 考] </p>
		 * 
		 * @return errorsフィールドのサイズ
		 */
		public function size():int {
			return errors.length;
		}
		
		/**
		 * <p>[概 要] </p>
		 * 引数errorをValidateErrorsリストに追加します.
		 * 
		 * <p>[詳 細] </p>
		 * errorsフィールドに引数errorを追加します。
		 * 
		 * <p>[備 考] </p>
		 * 
		 * @param error 一バリデーションエラーオブジェクト
		 */
	 	public function addError(error:ValidateError):void {
			errors.push(error);
		}
		
		/**
		 * <p>[概 要] </p>
		 * 引数指定されたインデックスのValidateErrorオブジェクトを返却します.
		 * 
		 * <p>[詳 細] </p>
		 * errorsフィールドのindex番目を取得、返却します。 
		 * 
		 * <p>[備 考] </p>
		 * 
		 * @param index errorsフィールドのインデックス
		 * @return indexに対応するValidateErrorオブジェクト
		 */
		public function getError(index:int):ValidateError {
			return errors[index];
		}
		
		/**
		 * <p>[概 要] </p>
		 * 引数componentがバリデーションエラーに含まれるか調べます.
		 * 
		 * <p>[詳 細] </p>
		 * errorsプロパティ内の各errorSourceObjectと引数componentが等しいかどうか調べます。
		 * 
		 * <p>[備 考] </p>
		 * 
		 * @param component バリデーションエラーを起こしたかどうか調べたコンポーネント
		 * @return true : エラー
		 */
		public function contains(component:Object):Boolean {
			var ret:Boolean = false;
			
			for each(var error:ValidateError in errors) {
				if(error.errorSourceObject == component) {
					ret = true;
					break;
				} 
			}
			
			return ret;
		}
	}
}
