/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.config.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.co.fujitsu.reffi.client.config.ImportDocument;
import jp.co.fujitsu.reffi.client.config.ReffiClientConfigDocument;
import jp.co.fujitsu.reffi.client.config.exception.ConfigException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class ConfigCheck {
    private static final String DEFAULT_CONFIG_FILE = "reffi-client-config.xml";
    private static final Log LOG = LogFactory.getLog(ConfigCheck.class);

    public void run() throws ConfigException {
        try {
            this.validate(DEFAULT_CONFIG_FILE);
        }
        catch (XmlException e) {
            LOG.error((Object)"XmlException", (Throwable)e);
            throw new ConfigException(e);
        }
        catch (IOException e) {
            LOG.error((Object)"IOException", (Throwable)e);
            throw new ConfigException(e);
        }
    }

    private void printErrors(List<XmlError> errors) {
        LOG.info((Object)"Erros discovered during validation:");
        for (XmlError error : errors) {
            String errorCode = error.getErrorCode();
            int line = error.getLine();
            int column = error.getColumn();
            String message = error.getMessage();
            LOG.error((Object)(">> " + errorCode + ": " + message + " (" + line + ", " + column + ")"));
        }
    }

    private void validate(String resourceFile) throws XmlException, IOException {
        ArrayList<XmlError> errors = new ArrayList<XmlError>();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setErrorListener(errors);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceFile);
        ReffiClientConfigDocument document = ReffiClientConfigDocument.Factory.parse(inputStream);
        boolean ret = document.validate(xmlOptions);
        if (!ret) {
            LOG.error((Object)(resourceFile + ": errors found."));
            this.printErrors(errors);
        } else {
            LOG.info((Object)(resourceFile + ": no errors found."));
        }
        ImportDocument.Import[] imports = document.getReffiClientConfig().getImportArray();
        for (int i = 0; i < imports.length; ++i) {
            this.validate(imports[i].getResource());
        }
    }

    public static void main(String[] argv) throws Exception {
        ConfigCheck configCheck = new ConfigCheck();
        configCheck.run();
    }
}

