/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jp.co.fujitsu.reffi.client.swing.event.MessageDialogEvent;
import jp.co.fujitsu.reffi.client.swing.listener.MessageDialogListener;

public class MessageDialog
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 3623505668973825850L;
    public static String defaultButtonText = "\u4e86\u89e3";
    public static String yesButtonText = "\u306f\u3044";
    public static String noButtonText = "\u3044\u3044\u3048";
    public static String cancelButtonText = "\u30ad\u30e3\u30f3\u30bb\u30eb";
    public static String okButtonText = "OK";
    private int returnValue;
    private List<MessageDialogListener> listenerList = new ArrayList<MessageDialogListener>();
    private String message;
    private String title;
    private int messageType;
    private int buttonOption;

    public int getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(int returnValue) {
        this.returnValue = returnValue;
    }

    public void addMessageDialogListener(MessageDialogListener listener) {
        if (listener != null) {
            this.listenerList.add(listener);
        }
    }

    public void removeMessageDialogListener(MessageDialogListener listener) {
        this.listenerList.remove(listener);
    }

    protected MessageDialog(Window owner, Dialog.ModalityType modalType, String message, String title, int messageType, int buttonOption) {
        super(owner, modalType);
        this.message = message;
        this.title = title;
        this.messageType = messageType;
        this.buttonOption = buttonOption;
        this.initUI();
    }

    protected int showDialog() {
        if (this.getOwner() != null) {
            this.setLocationRelativeTo(this.getOwner());
        }
        this.setVisible(true);
        return this.returnValue;
    }

    protected void initUI() {
        JButton[] buttons;
        this.setTitle(this.title);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        JPanel jpNorth = new JPanel();
        jpNorth.setLayout(new FlowLayout(0, 20, 5));
        Icon icon = this.createMessageTypeIcon(this.messageType);
        JLabel jlIcon = new JLabel(icon);
        jpNorth.add(jlIcon);
        JLabel jlMessage = new JLabel();
        jlMessage.setText(this.message);
        jpNorth.add(jlMessage);
        JPanel jpSouth = new JPanel();
        jpSouth.setLayout(new FlowLayout(1));
        for (JButton button : buttons = this.createButtons(this.buttonOption)) {
            jpSouth.add(button);
        }
        contentPane.add((Component)jpNorth, "North");
        contentPane.add((Component)jpSouth, "South");
        this.addWindowListener(this);
        this.pack();
    }

    protected Icon createMessageTypeIcon(int messageType) {
        Icon icon = null;
        switch (messageType) {
            case 0: {
                icon = UIManager.getIcon("OptionPane.errorIcon");
                break;
            }
            case 1: {
                icon = UIManager.getIcon("OptionPane.informationIcon");
                break;
            }
            case 2: {
                icon = UIManager.getIcon("OptionPane.warningIcon");
                break;
            }
            case 3: {
                icon = UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return icon;
    }

    protected JButton[] createButtons(int buttonOption) {
        JButton[] buttons = null;
        ArrayList<JButton> buttonList = new ArrayList<JButton>();
        switch (buttonOption) {
            case -1: {
                buttonList.add(new JButton(defaultButtonText));
                ((JButton)buttonList.get(0)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MessageDialog.this.setReturnValue(-1);
                        MessageDialog.this.setVisible(false);
                        MessageDialog.this.dispose();
                    }
                });
                break;
            }
            case 0: {
                buttonList.add(new JButton(yesButtonText));
                ((JButton)buttonList.get(0)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MessageDialog.this.setReturnValue(0);
                        MessageDialog.this.setVisible(false);
                        MessageDialog.this.dispose();
                    }
                });
                buttonList.add(new JButton(noButtonText));
                ((JButton)buttonList.get(1)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MessageDialog.this.setReturnValue(1);
                        MessageDialog.this.setVisible(false);
                        MessageDialog.this.dispose();
                    }
                });
                break;
            }
            case 1: {
                buttonList.add(new JButton(yesButtonText));
                ((JButton)buttonList.get(0)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MessageDialog.this.setReturnValue(0);
                        MessageDialog.this.setVisible(false);
                        MessageDialog.this.dispose();
                    }
                });
                buttonList.add(new JButton(noButtonText));
                ((JButton)buttonList.get(1)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MessageDialog.this.setReturnValue(1);
                        MessageDialog.this.setVisible(false);
                        MessageDialog.this.dispose();
                    }
                });
                buttonList.add(new JButton(cancelButtonText));
                ((JButton)buttonList.get(2)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MessageDialog.this.setReturnValue(2);
                        MessageDialog.this.setVisible(false);
                        MessageDialog.this.dispose();
                    }
                });
                break;
            }
            case 2: {
                buttonList.add(new JButton(okButtonText));
                ((JButton)buttonList.get(0)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MessageDialog.this.setReturnValue(0);
                        MessageDialog.this.setVisible(false);
                        MessageDialog.this.dispose();
                    }
                });
                buttonList.add(new JButton(cancelButtonText));
                ((JButton)buttonList.get(1)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MessageDialog.this.setReturnValue(2);
                        MessageDialog.this.setVisible(false);
                        MessageDialog.this.dispose();
                    }
                });
            }
        }
        double maxHeight = 0.0;
        double maxWidth = 0.0;
        for (JButton b : buttonList) {
            Dimension d = b.getPreferredSize();
            maxHeight = d.getHeight() > maxHeight ? d.getHeight() : maxHeight;
            maxWidth = d.getWidth() > maxWidth ? d.getWidth() : maxWidth;
        }
        Dimension buttonSize = new Dimension();
        buttonSize.setSize(maxWidth, maxHeight);
        for (JButton b : buttonList) {
            b.setPreferredSize(buttonSize);
        }
        buttons = buttonList.toArray(new JButton[0]);
        return buttons;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        for (MessageDialogListener listener : this.listenerList) {
            MessageDialogEvent event = new MessageDialogEvent(this, this.getReturnValue());
            listener.dialogClosed(event);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

