/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.model;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.naming.NamingException;
import jp.co.fujitsu.reffi.client.swing.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.swing.manager.JMSConsumeCoreManager;
import jp.co.fujitsu.reffi.client.swing.model.BaseModel;

public class JMSConsumeCore
extends BaseModel
implements MessageListener {
    private String identifier;
    private boolean unconsume;
    private Hashtable<String, String> environment;
    private QueueConnection queueConnection;
    private QueueSession queueSession;
    private Queue queue;
    private String queueName;
    private MessageConsumer consumer;
    private String connectionFactoryName = "ConnectionFactory";
    private String clientId;
    private boolean fireSuccessEventImmediately;

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean isUnconsume() {
        return this.unconsume;
    }

    public void setUnconsume(boolean unconsume) {
        this.unconsume = unconsume;
    }

    public Hashtable<String, String> getEnvironment() {
        if (this.environment == null) {
            this.environment = this.getController().getClientConfig().getDefaultJmsEnvironment();
        }
        return this.environment;
    }

    public void setEnvironment(Hashtable<String, String> environment) {
        this.environment = environment;
    }

    public QueueConnection getQueueConnection() {
        return this.queueConnection;
    }

    public void setQueueConnection(QueueConnection queueConnection) {
        this.queueConnection = queueConnection;
    }

    public QueueSession getQueueSession() {
        return this.queueSession;
    }

    public void setQueueSession(QueueSession queueSession) {
        this.queueSession = queueSession;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isFireSuccessEventImmediately() {
        return this.fireSuccessEventImmediately;
    }

    public void setFireSuccessEventImmediately(boolean fireSuccessEventImmediately) {
        this.fireSuccessEventImmediately = fireSuccessEventImmediately;
    }

    @Override
    protected void mainproc() throws NamingException, JMSException {
        if (!this.isUnconsume()) {
            JMSConsumeCoreManager.getInstance().consume(this.getQueueName(), this);
            if (this.isFireSuccessEventImmediately()) {
                ModelProcessEvent evt = new ModelProcessEvent(this);
                evt.setResult(null);
                this.fireModelSuccess(evt);
            }
        } else {
            JMSConsumeCoreManager.getInstance().unconsume(this.getQueueName(), this.getIdentifier());
            ModelProcessEvent evt = new ModelProcessEvent(this);
            evt.setResult(null);
            this.fireModelSuccess(evt);
            this.fireModelFinished(new ModelProcessEvent(this));
        }
    }

    public void onMessage(Message msg) {
        this.setResult(msg);
        this.postConsume(msg);
        ModelProcessEvent successEvent = new ModelProcessEvent(this);
        successEvent.setResult(msg);
        this.fireModelSuccess(successEvent);
    }

    protected void postConsume(Message msg) {
    }

    public final void onUnconsume() {
        this.postUnconsume();
        ModelProcessEvent finishedEvent = new ModelProcessEvent(this);
        this.fireModelFinished(finishedEvent);
    }

    protected void postUnconsume() {
    }
}

