/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.manager;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.util.ArrayList;
import java.util.List;
import jp.co.fujitsu.reffi.client.swing.listener.WindowOpenShutListener;

public class WindowManager {
    public static final int BASE = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    private static WindowManager windowManager;
    private List<WindowOpenShutListener> listenerList = new ArrayList<WindowOpenShutListener>();
    private List<Window> windowList = new ArrayList<Window>();

    public List<WindowOpenShutListener> getListenerList() {
        return this.listenerList;
    }

    public void setListenerList(List<WindowOpenShutListener> listenerList) {
        this.listenerList = listenerList;
    }

    public List<Window> getWindowList() {
        return this.windowList;
    }

    public void setWindowList(List<Window> windowList) {
        this.windowList = windowList;
    }

    private WindowManager() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent evt) {
                if (evt.getID() == 200) {
                    for (WindowOpenShutListener l : WindowManager.this.listenerList) {
                        WindowManager.this.windowList.add((Window)evt.getSource());
                        l.windowOpen(evt);
                    }
                }
                if (evt.getID() == 201) {
                    for (WindowOpenShutListener l : WindowManager.this.listenerList) {
                        WindowManager.this.windowList.remove(evt.getSource());
                        l.windowShut(evt);
                    }
                }
            }
        }, 64L);
    }

    public static WindowManager getInstance() {
        if (windowManager == null) {
            windowManager = new WindowManager();
        }
        return windowManager;
    }

    public void addWindowOpenShutListener(WindowOpenShutListener listener) {
        this.listenerList.add(listener);
    }

    public void removeWindowOpenShutListener(WindowOpenShutListener listener) {
        this.listenerList.remove(listener);
    }

    public void showWindow(Window window, boolean duplicate) {
        Window target = null;
        if (duplicate) {
            target = window;
        } else {
            Window w = null;
            w = this.getWindowByName(window.getName());
            if (w != null) {
                window.dispose();
                target = w;
            } else {
                target = window;
            }
        }
        target.setVisible(true);
    }

    public void showWindow(Window window, boolean duplicate, String baseWindowName, int position) {
        Window baseWindow = this.getWindowByName(baseWindowName);
        this.showWindow(window, duplicate, baseWindow, position);
    }

    public void showWindow(Window window, boolean duplicate, Window baseWindow, int position) {
        if (baseWindow != null) {
            Point movePoint = new Point();
            Point p = baseWindow.getLocation();
            Dimension d = baseWindow.getSize();
            switch (position) {
                case 0: {
                    movePoint.x = p.x + 10;
                    movePoint.y = p.y + 10;
                    break;
                }
                case 1: {
                    movePoint.x = p.x + d.width;
                    movePoint.y = p.y;
                    break;
                }
                case 2: {
                    movePoint.x = p.x;
                    movePoint.y = p.y + d.height;
                }
            }
            window.setLocation(movePoint);
        }
        this.showWindow(window, duplicate);
    }

    public Window getWindowByName(String windowName) {
        Window ret = null;
        for (Window w : this.windowList) {
            if (!windowName.equals(w.getName())) continue;
            ret = w;
            break;
        }
        return ret;
    }

    public Window[] getWindowsByName(String windowName) {
        ArrayList<Window> ret = new ArrayList<Window>();
        for (Window w : this.windowList) {
            if (!windowName.equals(w.getName())) continue;
            ret.add(w);
        }
        return ret.toArray(new Window[1]);
    }

    public boolean existSameNameWindow(Window window) {
        return this.existSameNameWindow(window.getName());
    }

    public boolean existSameNameWindow(String windowName) {
        boolean ret = false;
        for (Window w : this.windowList) {
            if (!windowName.equals(w.getName())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public Window searchActiveWindow() {
        Window ret = null;
        List<Window> windows = this.getWindowList();
        for (Window window : windows) {
            if (!window.isActive()) continue;
            ret = window;
            break;
        }
        return ret;
    }
}

