/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jp.co.fujitsu.reffi.client.swing.action.AbstractAction;
import jp.co.fujitsu.reffi.client.swing.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.swing.model.TimerProcessCore;

public class TimerProcessCoreManager {
    private static TimerProcessCoreManager instance;
    private Map<String, TimerProcessCore> timers = new HashMap<String, TimerProcessCore>();

    public Map<String, TimerProcessCore> getTimers() {
        return this.timers;
    }

    public void setTimers(Map<String, TimerProcessCore> timers) {
        this.timers = timers;
    }

    private TimerProcessCoreManager() {
    }

    public static TimerProcessCoreManager getInstance() {
        if (instance == null) {
            instance = new TimerProcessCoreManager();
        }
        return instance;
    }

    public boolean isRegist(String timerId) {
        return this.getTimers().containsKey(timerId);
    }

    public boolean start(final TimerProcessCore timerProcessCore) {
        if (this.isRegist(timerProcessCore.getTimerId())) {
            return false;
        }
        ScheduledThreadPoolExecutor executorService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
        executorService.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        timerProcessCore.setExecutorService(executorService);
        ScheduledFuture<?> future = executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (timerProcessCore.getIntervalAction() != null) {
                    ParameterMapping mapping = timerProcessCore.getParameterMapping().clone();
                    mapping.setAllowInteruptedExceptionOnSyncModel(true);
                    Class<? extends AbstractAction> action = timerProcessCore.getIntervalAction();
                    timerProcessCore.getController().invoke(action, mapping);
                } else {
                    timerProcessCore.onTick();
                }
            }
        }, timerProcessCore.getInitialDelay(), timerProcessCore.getPeriod(), TimeUnit.MILLISECONDS);
        timerProcessCore.setFuture(future);
        this.getTimers().put(timerProcessCore.getTimerId(), timerProcessCore);
        if (timerProcessCore.getStopLater() > 0L) {
            this.stop(timerProcessCore.getTimerId(), timerProcessCore.getStopLater());
        }
        return true;
    }

    public boolean stop(String timerId) {
        return this.stop(timerId, 0L);
    }

    private boolean stop(final String timerId, long stopLater) {
        if (!this.isRegist(timerId)) {
            return false;
        }
        TimerProcessCore timerProcessCore = this.getTimers().get(timerId);
        timerProcessCore.getExecutorService().schedule(new Runnable(){

            @Override
            public void run() {
                TimerProcessCoreManager.this.stopImmediately(timerId);
            }
        }, stopLater, TimeUnit.MILLISECONDS);
        return true;
    }

    public boolean stopImmediately(String timerId) {
        if (!this.isRegist(timerId)) {
            return false;
        }
        TimerProcessCore timerProcessCore = this.getTimers().get(timerId);
        timerProcessCore.onStop();
        timerProcessCore.getFuture().cancel(true);
        timerProcessCore.getExecutorService().shutdownNow();
        this.getTimers().remove(timerId);
        return true;
    }
}

