/*
 * Copyright (c) 2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.swing.helper;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

import jp.co.fujitsu.reffi.client.swing.action.AbstractAction;
import jp.co.fujitsu.reffi.client.swing.action.BaseAction;
import jp.co.fujitsu.reffi.client.swing.controller.BaseController;
import jp.co.fujitsu.reffi.client.swing.controller.EventBinder;
import jp.co.fujitsu.reffi.client.swing.manager.WindowManager;
import jp.co.fujitsu.reffi.client.swing.model.Model;
import jp.co.fujitsu.reffi.client.swing.util.ComponentSearchUtil;

/**
 * <p>[概 要] </p>
 * 
 * <p>[詳 細] </p>
 * 
 * <p>[備 考] </p>
 * 
 * 
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class CorrelationBuilder {

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param controller
	 * @return
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws SecurityException
	 * @throws NoSuchMethodException
	 * @throws IllegalArgumentException
	 * @throws InvocationTargetException
	 */
	public static ClassNode build(BaseController controller) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
		ClassNode controllerNode = 
			new ClassNode(ClassNode.CONTROLLER_NODE, 
					controller.getClass().getPackage().toString(), 
					controller.getClass().getSimpleName());
		
		EventBinder eventBinder = controller.getEventBinder();
		List<Window> windowList = WindowManager.getInstance().getWindowList();
		for(Window window : windowList) {
			ClassNode viewNode = 
				new ClassNode(ClassNode.VIEW_NODE, window.getClass().getPackage().toString(), window.getClass().getSimpleName());
			controllerNode.addChild(viewNode);
			
			List<Component> componentList = new ArrayList<Component>();
			ComponentSearchUtil.searchComponentsByName(componentList, window, "*");
			for(Component c : componentList) {
				String componentName = c.getName();
				if(componentName != null && componentName.length() != 0) {
					if(eventBinder.isEventBinding(componentName)) {
						List<Class<? extends EventListener>> listenerTypes = 
							eventBinder.getListenerTypes(componentName);
						for(Class<? extends EventListener> listenerType : listenerTypes) {
							List<String> eventTypes = 
								eventBinder.getEventTypes(componentName, listenerType);
							for(String eventType : eventTypes) {
								Class<? extends AbstractAction> actionClass = 
									eventBinder.getActionClass(componentName, listenerType, eventType);
								ClassNode actionNode =
									new ClassNode(ClassNode.ACTION_NODE, actionClass.getPackage().toString(), actionClass.getSimpleName());
								viewNode.addChild(actionNode);

								AbstractAction action = actionClass.newInstance();
								
								Method method = BaseAction.class.getDeclaredMethod("reserveModels", new Class[]{List.class});
								method.setAccessible(true);
								
								List<Class<? extends Model>> models = new ArrayList<Class<? extends Model>>(); 
								method.invoke(action, models);
								for(Class<? extends Model> modelClass : models) {
									ClassNode modelNode =
										new ClassNode(ClassNode.MODEL_NODE, modelClass.getPackage().toString(), modelClass.getSimpleName());
									actionNode.addChild(modelNode);
								}
							}
						}
					}
				}
			}
		}
		
		return controllerNode;
	}
}
