/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.listener;

import com.nexaweb.client.netservice.NetServiceException;
import com.nexaweb.messaging.MessageListener;
import com.nexaweb.util.XmlSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.co.fujitsu.reffi.client.nexaweb.model.SubscribeCore;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;

public enum SubscribeManager {
    instance;

    private Map<String, List<SubscribeCore>> _subscriberMap = new HashMap<String, List<SubscribeCore>>();

    public List<String> getSubscribingTopicNames() {
        ArrayList<String> topicNames = new ArrayList<String>();
        Set<String> topics = this._subscriberMap.keySet();
        Iterator<String> it = topics.iterator();
        while (it.hasNext()) {
            topicNames.add(it.next());
        }
        return topicNames;
    }

    public boolean isSubscribing(String topic) {
        return this.getSubscribingTopicNames().contains(topic);
    }

    public void subscribe(String topic, SubscribeCore subscribeCore) throws CoreLogicException {
        List<Object> subscribeCoreList = null;
        if (!this._subscriberMap.containsKey(topic)) {
            subscribeCoreList = new ArrayList();
            this.startListening(topic, subscribeCore);
        } else {
            subscribeCoreList = this._subscriberMap.get(topic);
        }
        subscribeCoreList.add(subscribeCore);
        this._subscriberMap.put(topic, subscribeCoreList);
    }

    public void unsubscribe(String topic) throws CoreLogicException {
        this.unsubscribe(topic, null);
    }

    public void unsubscribe(String topic, String identifier) throws CoreLogicException {
        if (!this._subscriberMap.containsKey(topic)) {
            return;
        }
        try {
            if (identifier == null) {
                SubscribeCore subscribeCore = this._subscriberMap.get(topic).get(0);
                subscribeCore.getController().getSession().getMessagingService().unsubscribe(topic);
                subscribeCore.unsubscribeCompleted();
                this._subscriberMap.remove(topic);
            } else {
                List<SubscribeCore> subscribeCoreList = this._subscriberMap.get(topic);
                Iterator<SubscribeCore> itr = subscribeCoreList.iterator();
                while (itr.hasNext()) {
                    SubscribeCore subscribeCore = itr.next();
                    if (!identifier.equals(subscribeCore.getIdentifier())) continue;
                    subscribeCore.unsubscribeCompleted();
                    itr.remove();
                }
            }
        }
        catch (NetServiceException e) {
            throw new CoreLogicException("EFC1005", (Throwable)e);
        }
    }

    private void startListening(String topic, SubscribeCore subscribeCore) throws CoreLogicException {
        try {
            MessageListener messageListener = new MessageListener(){

                public void onMessage(String topic, Serializable obj) {
                    SubscribeManager.this.subscribeMessage(topic, obj);
                }

                public void onMessage(String topic, XmlSerializable obj) {
                    SubscribeManager.this.subscribeMessage(topic, obj);
                }

                public void onMessage(String topic, String string) {
                    SubscribeManager.this.subscribeMessage(topic, string);
                }
            };
            subscribeCore.getController().getSession().getMessagingService().subscribe(topic, messageListener);
        }
        catch (NetServiceException e) {
            throw new CoreLogicException("EFC1005", (Throwable)e);
        }
    }

    protected void subscribeMessage(String topic, Object result) {
        List<SubscribeCore> subscribeCoreList = this._subscriberMap.get(topic);
        Iterator<SubscribeCore> itr = subscribeCoreList.iterator();
        while (itr.hasNext()) {
            itr.next().subscribeCompleted(result);
        }
    }
}

