/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.model {

	import jp.co.fujitsu.reffi.client.flex.events.ModelProcessEvent;
	
	/**
	 * <p>[概 要]</p>
	 * デフォルトモデルクラスです.
	 * 
	 * <p>[詳 細]</p>
	 * コントローラに１つもモデルを実行委譲しなかった場合
	 * （アクションでモデルをリザーブしなかった場合）、コントローラによって代替採用される
	 * モデルクラスです。<br>
	 * イベントハンドル時の処理シーケンスを均一化する為に使用されます。<br>
	 * デフォルトモデルとして他のクラスを採用する場合は、ClientConfigクラスの
	 * defaultModelClassプロパティに設定してください。
	 * 
	 * <p>[備 考]</p>
	 *
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 * @see jp.co.fujitsu.reffi.client.flex.controller.ClientConfig
	 */
	public class DefaultModel extends BaseModel {

		/**
		 * <p>[概 要]</p>
		 * モデル処理成功イベントとモデル処理完了イベントを発行します.
		 * 
		 * <p>[詳 細]</p>
		 * DefaultModelに具体的な処理は有りません。<br>
		 * モデル処理フロー終了時に、成功イベントと完了イベントを発行して終了します。
		 * 
		 * <p>[備 考]</p>
		 */
		override protected function postProc() : void {
			dispatchModelSuccess(new ModelProcessEvent(ModelProcessEvent.SUCCESS));
			dispatchModelFinished(new ModelProcessEvent(ModelProcessEvent.FINISHED));
		}

		/**
		 * <p>[概 要]</p>
		 * モデル処理失敗イベントを発行します.
		 * 
		 * <p>[詳 細]</p>
		 * DefaultModelには具体的な処理が無い為、このメソッドがコールされることは
		 * 有りません。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param e 発生したエラーオブジェクト
		 * @return e 発生したエラーオブジェクト
		 */
		override protected function trap(e : Error) : Error {
			dispatchModelFailure(new ModelProcessEvent(ModelProcessEvent.FAILURE));
			return e;
		}
	}
}
