/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.nexaweb.validator;

import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValues;
import jp.co.fujitsu.reffi.client.nexaweb.parser.Parser;

import com.nexaweb.plugin.validation.exceptions.ValidationException;
import com.nexaweb.plugin.validation.validators.Validator;
import com.nexaweb.xml.Element;

/**
 * <p>[概 要]</p>
 * Reffiを使用したNexawebアプリケーションにおいて、全バリデータの基底クラスになります。
 * 
 * <p>[詳 細]</p>
 * 
 * <p>[備 考]</p>
 * 
 * @author Project Reffi
 */
public abstract class CustomValidator extends Validator {
	
	/** バリデーションエラーが発生した場合のエラーメッセージです。 */
	private String errorMessage;
	/** バリデーションエラーが発生した場合の見出し文字です。 */
	private String headWord;

	
	/**
	 * <p>[概 要]</p>
	 * バリデーションエラーが発生した場合のエラーメッセージを取得します。
	 * 
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * @return バリデーションエラーが発生した場合のエラーメッセージ
	 */
	public String getErrorMessage() {
		return this.errorMessage;
	}

	/**
	 * <p>[概 要]</p>
	 * バリデーションエラーが発生した場合のエラーメッセージを設定します。
	 * 
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * @param errorMessage バリデーションエラーが発生した場合のエラーメッセージ
	 */
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	/**
	 * <p>[概 要]</p>
	 * バリデーションエラーが発生した場合の見出し文字を取得します。
	 * 
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * @return バリデーションエラーが発生した場合の見出し文字
	 */
	public String getHeadWord() {
		return this.headWord;
	}

	/**
	 * <p>[概 要]</p>
	 * バリデーションエラーが発生した場合の見出し文字を設定します。
	 * 
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * @param headWord バリデーションエラーが発生した場合の見出し文字
	 */
	public void setHeadWord(String headWord) {
		this.headWord = headWord;
	}


	/**
	 * <p>[概 要]</p>
	 * エラーメッセージ登録メソッドです。
	 *  
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 * 具象バリデータクラスは必ず実装する必要が有ります。
	 * バリデーションエラーになった場合のメッセージを返却するよう実装して下さい。
	 * 
	 * <pre class="samplecode">
	 *	public class MoneyValidator extends CustomValidator{
	 *		&#064;Override
	 *		protected String registerErrorMessage(){
	 *			return "金額が不足しています。";
	 *		}
	 * 			:
	 * 			:
	 * </pre>
	 */
	protected abstract String registerErrorMessage();
	
	/**
	 * <p>[概 要]</p>
	 * コンストラクタです。
	 *  
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 *  
	 * @param element バリデーション対象エレメント
	 */
	public CustomValidator(Element element) {
		super();
		
		setElement(element);
		setErrorMessage(registerErrorMessage());
		setHeadWord(element.getAttribute("name"));
	}
	
	/**
	 * <p>[概 要]</p>
	 * バリデーション対象エレメントの値を返却します。
	 *  
	 * <p>[詳 細]</p>
	 * このメソッドはcom.nexaweb.plugin.validation.validators.Validator#getValue()
	 * を戻り値ナローイングしてオーバーライドしています。<BR>
	 * 
	 * <p>[備 考]</p>
	 * このクラスを継承した全バリデータはバリデーション対象エレメントの値を
	 * ElementValues型として受け取ります。<BR>
	 * （各種バリデータはvalidateメソッドの引数としてこの戻り値を取得します）
	 * 
	 * @return バリデーション対象エレメントの値を持つオブジェクト
	 */
	@Override
	protected ElementValues getValue() throws ValidationException{

		// バリデーション対象のエレメントを取得
		Element element = getElement();
		// エレメントの種類毎に値を取得
		Parser parser = new ElementValueParser();
		ElementValues values = null;
		try{
			values = (ElementValues)parser.parse(element);
		}catch(Exception e){
			// ParserがCoreLogicExceptionをワイドニングスローするが、
			// Validator#getValue()はValidationExceptionしかスローできない。
			throw new ValidationException("", e);
		}
		
		return values;
	}
}
