/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.nexaweb.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class DynamicUrlFilter
implements Filter {
    private static String SEPARATOR = "/";
    private static String QUERY_HEAD = "?";

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String contextPath = req.getContextPath();
        if (contextPath != null && contextPath.equals(SEPARATOR)) {
            contextPath = "";
        }
        if (!StringUtils.isBlank((String)(path = this.getPath(req))) && path.contains("/AsyncReq")) {
            String[] names = StringUtils.split((String)path, (String)SEPARATOR);
            StringBuilder realPath = new StringBuilder(this.getActionPath(names));
            if (!StringUtils.isBlank((String)req.getQueryString())) {
                res.sendRedirect(contextPath + realPath.toString() + QUERY_HEAD + req.getQueryString());
                return;
            }
            this.forward(req, res, realPath.toString());
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private void forward(HttpServletRequest request, HttpServletResponse response, String actionPath) throws IOException, ServletException {
        String forwardPath = actionPath;
        request.getRequestDispatcher(forwardPath).forward((ServletRequest)request, (ServletResponse)response);
    }

    private String getPath(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (StringUtils.isEmpty((String)path)) {
            path = request.getServletPath();
        }
        return path;
    }

    private String getActionPath(String[] names) {
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < names.length; ++i) {
            sb.append(SEPARATOR).append(names[i]);
        }
        return sb.toString();
    }
}

