/*
 * Decompiled with CFR 0.152.
 */
package jp.recnavi.epg.site;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.recnavi.epg.site.ONTVPrefecture;

class ONTVDistrict {
    private String name;
    private ArrayList<String> prefectureNames = new ArrayList();
    private Hashtable<String, ONTVPrefecture> prefectures = new Hashtable();

    ONTVDistrict(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    private void clear() {
        this.prefectureNames.clear();
        this.prefectures.clear();
    }

    private void add(ONTVPrefecture prefecture) {
        String name = prefecture.getName();
        this.prefectureNames.add(name);
        this.prefectures.put(name, prefecture);
    }

    void setONTVPrefectures(String html) {
        this.clear();
        Pattern prefecture_pattern = Pattern.compile("<A [^']*'(\\w+)'[^>]*>([^<]*)</A>");
        Matcher matcher = prefecture_pattern.matcher(html);
        while (matcher.find()) {
            String code = matcher.group(1);
            String name = matcher.group(2);
            this.add(new ONTVPrefecture(name, code));
        }
    }

    Object[] getONTVPrefectureNames() {
        return this.prefectureNames.toArray();
    }

    ONTVPrefecture getONTVPrefecture(String name) {
        return this.prefectures.get(name);
    }
}

