/*
 * Decompiled with CFR 0.152.
 */
package jp.recnavi.epg.site;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstructWebPage {
    private String html;
    private String charset;

    AbstructWebPage() {
    }

    protected abstract String getURL();

    public static String getCharset(String html) {
        Pattern pattern = Pattern.compile("charset=([\\w-]*)");
        Matcher matcher = pattern.matcher(html);
        return matcher.find() ? matcher.group(1) : "iso-8859-1";
    }

    protected String getCharset() {
        if (this.charset == null) {
            this.charset = AbstructWebPage.getCharset(this.getHTML());
        }
        return this.charset;
    }

    public static String getHTML(String url) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int size;
            byte[] buf = new byte[1024];
            InputStream in = new URL(url).openStream();
            while ((size = in.read(buf)) > 0) {
                buffer.write(buf, 0, size);
            }
        }
        catch (IOException e) {
            return "";
        }
        try {
            return buffer.toString(AbstructWebPage.getCharset(buffer.toString("iso-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            return buffer.toString();
        }
    }

    protected String getHTML() {
        if (this.html == null) {
            this.html = AbstructWebPage.getHTML(this.getURL());
        }
        return this.html;
    }
}

