PLOTSTAB <- function( filename, plotfile ) {
	data <- read.table( filename, sep = "\t", header = T );
	xdata <- subset( data, data["score2"] < 1000 );
	ydata <- subset( xdata, xdata["score1"] < 1000 );
	xma <- max( xdata$score1 );
	yma <- max( ydata$score2 );
	ma <- max( xma, yma )
#	png( file = paste( plotfile ), width = 750, height = 750, pointsize = 11, type = "Xlib" );
	png( file = paste( plotfile ), width = 750, height = 750 );
	par( mex = 1.5 )
	plot( ydata$score1, ydata$score2, xlim = c( 0, ma ), ylim = c( 0, ma ), xlab = paste( "Stability of replicate 1" ), ylab = paste( "Stability of replicate 2" ), cex = 0.8, pch = 16, cex.lab = 2, cex.axis = 1.5, col = ifelse( ( ydata$idr < 0.1 ), "green3", "red" ) );
	abline(0,1)
	dev.off();
}






