#!/bin/bash
#
# Copyright 2012 K.K.DNAFORM
# This file is part of idr_paraclu program.
# Idr_paraclu is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, any later version.
#
# Idr_paraclu is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar. If not, see <http://www.gnu.org/licenses/>.
#
# make clusters and calculate stabilities
#
# Usage :
#		makeCluster.sh <input> <output>		
# Parameter :  
#		input		input file
#		output		output file
# Date :
#		Creating	2011/08/15
#
##########################################################

## ----------------------------
## Parameter check
## ----------------------------
if [ "$#" -ne 2 ]; then
	echo "Usage : makeCluster.sh <input> <output>";
	exit 1;
fi
fileA=$1;
output=$2;

## -------------------------------------------
## run intersectBed
## -------------------------------------------
`intersectBedOhmiya -s -wo -a $fileA -b $fileA | \
	awk '$2 >= $8 && $3 <= $9 {print}' | \
	sort -k1,1 -k6,6 -k2,2n -k3,3n | uniq | \
	groupByOrg -g 1,2,3,6 -opCols 11 -ops sum -full | \
	awk '{print $1 "\t" $2 "\t" $3 "\t" $4 "\t" $19 "\t" $6 }' > $output`;

