#!/bin/bash
#
# Copyright 2012 K.K.DNAFORM
# This file is part of idr_paraclu program.
# Idr_paraclu is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, any later version.
#
# Idr_paraclu is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Foobar. If not, see <http://www.gnu.org/licenses/>.
#
# Run intersectBed and create the input file for IDR. 
#
# Usage :
#		intersectBED.sh <fileA> <fileB> <fraction> <output>		
# Parameter :  
#		fileA		a file compared to fileB in search of overlaps
#		fileB		another file compared
#		fraction	minimum overlap required as a franction of fileA
#		output		output file
# Date :
#		Creating	2011/07/13
#
##########################################################
## Path for intersectBed
INTERSECTBED_PATH=/home/ohmiya/bin;
## Path for groupByOrg
GROUPBYORG_PATH=/home/ohmiya/bin;


## ----------------------------
## Parameter check
## ----------------------------
if [ "$#" -ne 4 ]; then
	echo "Usage : intersectBED.sh <fileA> <fileB> <fraction> <output>";
	exit 1;
fi
fileA=$1;
fileB=$2;
fraction=$3;
output=$4;
tmp=$output".tmp";
tmp1=$output".tmp1";

## -------------------------------------------
## run intersectBed
## -------------------------------------------
intersectBedOhmiya -s -v -a $fileA -b $fileB -r -f $fraction | \
	awk 'BEGIN{OFS="\t"}{printf "%s\t%e\t%d\t%d\n", $1"_"$2"_"$3"_"$6, $5, -1, -1}' > $output

intersectBedOhmiya -s -v -a $fileB -b $fileA -r -f $fraction | \
	awk 'BEGIN{OFS="\t"}{printf "%d\t%d\t%s\t%e\n", -1, -1, $1"_"$2"_"$3"_"$6, $5}' >> $output

intersectBedOhmiya -s -wo -a $fileA -b $fileB -r -f $fraction | \
	awk 'BEGIN{OFS="\t"}{printf "%s\t%e\t%s\t%e\t%f\n", $1"_"$17"_"$18"_"$6, $5, $1"_"$17"_"$18"_"$6, $11, $16}' | \
	sort -k1,1 | \
	groupByOrg -g 1 -opCols 5 -ops max -full | \
	awk 'BEGIN{OFS="\t"}{printf "%s\t%s\t%s\t%s\n", $1, $2, $3, $4}' >> $output

intersectBedOhmiya -s -wo -a $fileA -b $fileB -r -f $fraction | \
	awk 'BEGIN{OFS="\t"}{printf "%s\t%e\t%s\t%e\t%e\t%d\n", $1"_"$17"_"$18"_"$6, $5, $1"_"$17"_"$18"_"$6, $11, $16, $13}' | \
	sort -k1,1 | \
	groupByOrg -g 1 -opCols 5 -ops max -full | \
	awk 'BEGIN{OFS="\t"}{printf "%s\t%s\t%s\n", $1, $3, $6}' >> $tmp

intersectBedOhmiya -s -wo -a $fileA -b $fileB -r -f $fraction | \
	awk 'BEGIN{OFS="\t"}{printf "%s\t%e\t%s\t%e\t%e\t%d\t%d\n", $1"_"$17"_"$18"_"$6, $5, $1"_"$17"_"$18"_"$6, $11, $16, $17, $18}' | \
	sort -k 1,1 | \
	groupByOrg -g 1 -opCols 5 -ops max -full | \
	awk 'BEGIN{OFS="\t"}{printf "%s\t%s\t%s\t%s\n", $1, $3, $6, $7}' >> $tmp1



