#!/bin/bash
directory=/usr/share/RUM
lightdmGreeters=lightdm.txt
sddmGreeters=sddm.txt

function isRebornOS() {
      true=0
      false=1
      if [ -f /etc/pacman.d/reborn-mirrorlist ]; then
            return $true
      else
            return $false
      fi
}

function FirstTime() {
      if [ -f $1 ]; then
            Install $2 $3 $4
            rm -f $1
      fi
      # If RebornOS is not the distro being run, check for updates
      if ! isRebornOS ; then
            localRUMFile=$($4/*zst | rev | cut -f1 -d "/" | rev)
            # Download a file with a list of all packages on the RebornOS repository
            curl -o rebornos.txt http://repo.rebornos.org/RebornOS/
            remoteRUMFile=$(grep "reborn-updates." rebornos.txt | cut -f2 -d "\"" | cut -d "\"" -f1 | grep -v "sig")
            # If the local RUM package file and the one from the server are not identical, install the updated one from Gitlab (aka. upgrade RUM without messing with signatures)
            if [ "$localRUMFile" != "$remoteRUMFile" ]; then
                  curl -o $4/$remoteRUMFile https://gitlab.com/reborn-os-team/reborn-updates-and-maintenance/-/raw/master/$remoteRUMFile
                  pkexec pacman -U $4/$remoteRUMFile --noconfirm
            fi
            # Remove old RUM file
            rm -f $4/$localRUMFile
            # Remove files generated by this function
            rm -f rebornos.txt
      fi
}

function Install() {
    RUID=$(who | awk 'FNR == 1 {print $1}')
    # Piece together the command to install packages via pacman
    command="pacman -S"
    while read package; do
        command+=" $package"
    done <$1
    command+=" --needed --noconfirm"
    echo "$command"
    # Download and install yay from the main RebornOS repository
    curl -o rebornos.txt http://repo.rebornos.org/RebornOS/
    yayFile=$(grep "yay" rebornos.txt | cut -f2 -d "\"" | cut -d "\"" -f1 | grep -v "sig")
    # Install packages with only one pkexec dialog
    pkexec bash $3/Bash/StartupChecks.sh PacmanYay "$command" $yayFile
    # Remove the downloaded pkg file
    rm -f $yayFile
    # Remove files generated by this function
    rm -f rebornos.txt
    # Launch the setting dialog so the user can select a terminal
    notify-send "Please select a terminal, and then close the window" -u critical -i "/usr/share/icons/default/reborn-updates.svg" -a "Reborn Updates and Maintenance"
    python3 $2
}

function PacmanYay()
{
      # Install necessary packages from pacman
      $1
      # Install yay
      wget http://repo.rebornos.org/RebornOS/$2
      pkexec pacman -U $2 --needed --noconfirm
      # Remove files generated by this function
      rm -f $2
}

function DisplayLightDMgreeters() {
      DMdirectory=$1
      ls /usr/share/lightdm-webkit/themes/ | sed "s|.desktop||g" >$DMdirectory/Settings/$lightdmGreeters
      if [ -f /etc/lightdm/lightdm-gtk-greeter.conf ]; then
            echo "lightdm-gtk-greeter" >>$DMdirectory/Settings/$lightdmGreeters
      fi
}

function DisplaySDDMgreeters() {
      DMdirectory=$1
      ls -l /usr/share/sddm/themes/ | awk '{print $9}' | sed 1d >$DMdirectory/Settings/$sddmGreeters
}

function StorePacmanLog()
{
      # Declare counter used for the line number in the transactions.txt file
      count=0
      # Empty the contents of transactions.txt completely
      if [ -f $1/Settings/transactions.txt ]; then
            cat /dev/null > $1/Settings/transactions.txt
      fi
      # Store list of last 10 pacman transaction dates and the information associated with them
      grep -n "transaction completed" /var/log/pacman.log | cut -f1 -d "T" | cut -d "[" -f2 | tail -n30 >$1/Settings/transactionInstances.txt
      grep -n "Running '" /var/log/pacman.log | cut -f2 -d "'" | tail -n30 >$1/Settings/transactionDetails.txt
      # Make the content of transactions.txt more human-readable
      while read line; do
            count=$((count+1))
            year=$(echo $line | cut -f1 -d "-")
            month=$(echo $line | cut -f2 -d "-")
            day=$(echo $line | rev | cut -d "-" -f1 | rev)
            # Convert month numbers to text
            if [ "$month" == "01" ]; then
                  month="January"
            elif [ "$month" == "02" ]; then
                  month="February"
            elif [ "$month" == "03" ]; then
                  month="March"
            elif [ "$month" == "04" ]; then
                  month="April"
            elif [ "$month" == "05" ]; then
                  month="May"
            elif [ "$month" == "06" ]; then
                  month="June"
            elif [ "$month" == "07" ]; then
                  month="July"
            elif [ "$month" == "08" ]; then
                  month="August"
            elif [ "$month" == "09" ]; then
                  month="September"
            elif [ "$month" == "10" ]; then
                  month="October"
            elif [ "$month" == "11" ]; then
                  month="November"
            else
                  month="December"
            fi
            # Store details of the transaction in a variable ingeniously named 'details'
            details=$(sed -n "$count p" < $1/Settings/transactionDetails.txt)
            # Create a meta-variable
            newLine="$month $day $year (Command: $details)"
            # Echo meta-variable into transactions.txt
            echo $newLine >> $1/Settings/transactions.txt
      done < $1/Settings/transactionInstances.txt
      # Reset counter
      count=0
      # Loop through file in order to eliminate lines from the same date
      while read line; do
            #increment and reset variables
            count=$((count+1))
            numberOfLines=$(wc -l $1/Settings/transactions.txt | awk '{print $1}')
            # Set values for current line
            month=$(sed -n "$count p" < $1/Settings/transactions.txt | awk '{print $1}')
            day=$(sed -n "$count p" < $1/Settings/transactions.txt | awk '{print $2}')
            year=$(sed -n "$count p" < $1/Settings/transactions.txt | awk '{print $3}')
            # Set values for next line
            nextMonth=$(sed -n "$((count+1)) p" < $1/Settings/transactions.txt | awk '{print $1}')
            nextDay=$(sed -n "$((count+1)) p" < $1/Settings/transactions.txt | awk '{print $2}')
            nextYear=$(sed -n "$((count+1)) p" < $1/Settings/transactions.txt | awk '{print $3}')
            # Set the counter variable for the while loop to begin at the value of $count
            newCount=$count
            echo "Loop"
            # While current line and next line are equal but we have not reached the end of the file, increment $newCount
            while [ "$year$month$day" == "$nextYear$nextMonth$nextDay" ] && [ $newCount -lt $numberOfLines ]; do
                  newCount=$((newCount+1))
                  nextMonth=$(sed -n "$((newCount+1)) p" < $1/Settings/transactions.txt | awk '{print $1}')
                  nextDay=$(sed -n "$((newCount+1)) p" < $1/Settings/transactions.txt | awk '{print $2}')
                  nextYear=$(sed -n "$((newCount+1)) p" < $1/Settings/transactions.txt | awk '{print $3}')
                  echo "Current: $month $day, $year"
                  echo "Next: $nextMonth $nextDay, $nextYear"
            done
            # If $newCount has been incremented in the while loop and we are not currently at the end of the file, delete the necessary lines
            if [ $newCount -ne $count ] && [ $count -lt $numberOfLines ]; then
                  sed -i "$(($count)),$((newCount-1)) d" $1/Settings/transactions.txt
            fi
      done < $1/Settings/transactions.txt
      # Reset count variable
      count=0
      # Format remaining lines for storing in transactions.txt
      while read line; do
            count=$((count+1))
            sed -i "$count s|.*|$count) $line|" $1/Settings/transactions.txt
            echo "$line"
      done < $1/Settings/transactions.txt
      # Remove files that are now unnecessary
      if [ -f $1/Settings/transactionInstances.txt ]; then
            rm -f $1/Settings/transactionInstances.txt
      fi
      if [ -f $1/Settings/transactionDetails.txt ]; then
            rm -f $1/Settings/transactionDetails.txt
      fi
}

export -f Install PacmanYay DisplayLightDMgreeters DisplaySDDMgreeters FirstTime StorePacmanLog isRebornOS

"$@"
