##
## Coptright(c) Bluemoon inc.
##
CREATE TABLE realty_detail (
  `id` bigint AUTO_INCREMENT,								# id
  `property_id` bigint,										# 物件番号
  `title` varchar(255) default NULL,						# タイトル
  `text` text default NULL,									# コンテンツ
  `visible` tinyint(1) NOT NULL default 0,
  `recommends` tinyint(1) NOT NULL default 0,
  `nohtml` tinyint(1) NOT NULL default 0,
  `nosmiley` tinyint(1) NOT NULL default 0,
  `nobreaks` tinyint(1) NOT NULL default 0,
  `nocomments` tinyint(1) NOT NULL default 0,
  `link` tinyint(1) NOT NULL default 0,
  `address` varchar(255) default NULL,
  `submenu` tinyint(1) NOT NULL default 0,
  `last_modified` timestamp(14),
  `created` datetime,
  `html_header` text default NULL,
  `railline_name` text ,									# 沿線略称（1）,
  `station_name` text ,										# 駅名（1）,
  `transit` text ,											# 交通
  `price` double,											# 価格,
  `layout_desc` varchar(24) default NULL,					# Room Layout,
  `realty_switch` tinyint(1),								# 賃貸フラグ( 0=売買 )
  KEY (realty_switch),
  KEY (property_id),
  PRIMARY KEY (id)
) TYPE=MyISAM;


CREATE TABLE realty_sale (
  `id` bigint AUTO_INCREMENT,								# id
  `property_id` bigint,										# 物件番号
  `data_id` tinyint(1),										# データ種類
  `type_id` tinyint(1),										# 物件種別(土地、戸建、マン[マンション等]、外全[住宅以外の建物全部]、外一[住宅以外の建物一部]、居住[賃貸居住用]、事業[賃貸事業用]）
  `land_id` tinyint(1),										# 物件種目（売地、借地権、底地権）
  `member_name` text,										# 会員名,
  `member_phone` varchar(12),								# 代表電話番号,
  `contact_person` varchar(32),								# 問合せ担当者（1）,
  `contact_phone` varchar(12),								# 問合せ電話番号（1）,
  `contact_email` varchar(64),								# Eメールアドレス（1）,
  `drawing` tinyint(1),										# 図面,
  `created` date,											# 登録年月日,
  `updated` date,											# 変更年月日,
  `expired` date,											# 取引条件の有効期限,
  `used` tinyint(1)  ,										# 新築中古区分,1=区分無し、2=新築
  `prefecture` varchar(8),									# 都道府県名,
  `county` varchar(16) ,									# 所在地名1,市区
  `township` varchar(32) ,									# 所在地名2,町村
  `address1` text ,											# 所在地名3,番地
  `address2` text ,											# 建物名
  `address3` text ,											# 部屋番号,
  `address4` text ,											# その他所在地表示,
  `address5` text ,											# 棟番号,
  `railline_name` text ,									# 沿線略称（1）,
  `station_name` text ,										# 駅名（1）,
  `twf_station` tinyint ,									# 徒歩（分）1（1）,
  `dnf_station` tinyint ,									# 徒歩（m）2（1）,
  `tbf_station` tinyint ,									# バス（1）,
  `busline_name` text ,										# バス路線名（1）,
  `busstop_name` text ,										# バス停名称（1）,
  `twf_bustop` tinyint(1)  ,								# 停歩（分）（1）,
  `dnf_bustop` tinyint(1)  ,								# 停歩（m）（1）,
  `tcf_station` tinyint(1)  ,								# 車（km）（1）,
  `other_transit` text ,									# その他交通手段,
  `twf_other` tinyint(1)  ,									# 交通（分）1,
  `dnf_other` tinyint(1)  ,									# 交通（m）2,
  `inspection_rate` tinyint(1)  ,							# 現況,検査
  `inspection_date` date,									# 現況予定年月,
  `delivery_term` tinyint(1)  ,								# 引渡時期,
  `delivery_ym` int,										# 引渡年月（西暦）,
  `delivery_bme` tinyint(1)  ,								# 引渡旬,
  `movingin_ym` char(6)  ,									# 入居年月（西暦）,
  `movingin_day` tinyint(1),								# 入居日,
  `dealings_mode` tinyint(1),								# 取引態様,（専属・専任・一般・他）
  `reward_form` tinyint(1),									# 報酬形態,
  `commission_ratio` double,								# 手数料割合率,
  `commission_fee` tinyint(1),								# 手数料,
  `price` double,											# 価格,
  `tax` double,												# 価格消費税,
  `tsubo_unitprice` double,									# 坪単価,
  `squaremeter_unitprice` double,							# ㎡単価,
  `assumption_yield` double,								# 想定利回り（％）,
  `area_measurement_method` tinyint,						# 面積計測方式,
  `area_of_land` double,									# 土地面積,
  `land_common_share_area` double,							# 土地共有持分面積,
  `land_common_share_molecule` int,							# 土地共有持分（分子）,
  `land_common_share_denominator` int, 						# 土地共有持分（分母）,
  `area_of_building` double,								# 建物面積1,
  `monopolize_area` double,									# 専有面積,
  `private_road_load_existence` tinyint(1),					# 私道負担有無,
  `private_road_area` double,								# 私道面積,
  `area_of_terrace` double,									# バルコニー（テラス）面積,
  `area_of_private_garden` double,							# 専用庭面積,
  `set_back_division` tinyint(1),							# セットバック区分,
  `setback_distance` int,									# 後退距離（m）,
  `area_of_setback` double,									# セットバック面積（㎡）,
  `gross_area` double,										# 開発面積／総面積,
  `sales_total_area` double,								# 販売総面積,
  `number_of_sales_divisions` int,							# 販売区画数,
  `construction_completion_date` date,						# 工事完了年月（西暦）,
  `building_area` double,									# 建築面積,
  `total_area` double,										# 延べ面積,
  `presence_of_site_extension` tinyint(1),					# 敷地延長の有無,
  `site_extension` double,									# 敷地延長（30%以上表示）,
  `tenancy_rate` double,									# 借地料,
  `leased_land_period` int,									# 借地期間,
  `leased_land_time_limit` date,							# 借地期限（西暦）,
  `facility_expenses_item` text,							# 施設費用項目（1）,
  `facility_expenses` double,								# 施設費用（1）,
  `report_to_government` int,								# 国土法届出,
  `registry_book_land_classification` text,					# 登記簿地目,
  `current_state_land_classification` text,					# 現況地目,
  `city_planning` text,										# 都市計画,
  `use_district_1` text,									# 用途地域（1）,
  `use_district_2` text,									# 用途地域（2）,
  `the_best_usage` text,									# 最適用途,
  `building_coverage` double,								# 建ぺい率,
  `ratio_of_building_volume_to_lot` double,					# 容積率,
  `regional_district` text,									# 地域地区,
  `rand_right` tinyint(1), 									# 土地権利,
  `incidental_right` tinyint(1),							# 付帯権利,
  `building_transfer_money` double,							# 造作譲渡金,
  `fixed_borrowing_premium` double,							# 定借権利金,
  `fixed_borrowing_guarantee_money` double,					# 定借保証金,
  `fixed_borrowing_deposit` double,							# 定借敷金,
  `topology` tinyint(1),									# 地勢,
  `architectural_condition` tinyint(1),						# 建築条件,
  `owner_change` tinyint(1),								# オーナーチェンジ,
  `management_union_existence` tinyint(1),					# 管理組合有無,
  `management_form` tinyint(1),								# 管理形態,
  `management_company_name` text,							# 管理会社名,
  `manager_situation` tinyint(1),							# 管理人状況,
  `maintenance_fee` double,									# 管理費,
  `maintenance_fee_tax` double,								# 管理費消費税,
  `mending_reserve_fund` double,							# 修繕積立金,
  `other_monthly_expense_name` text,						# その他月額費名称1,
  `other_monthly_expense_fee` double,						# その他月額費用金額1,
  `donor_name` text,										# 施主,
  `construction_company_name` text,							# 施工会社名,
  `company_of_selling_in_lots_name` text,					# 分譲会社名,
  `total_sub_contracting_person` text,						# 一括下請負人,
  `touching_road_situation` tinyint(1),						# 接道状況,
  `touching_road1_type` tinyint(1),							# 接道種別1,
  `touching_road1_touching_side` tinyint(1),				# 接道接面1,
  `touching_road1_positional_specification` tinyint(1),		# 接道位置指定1,
  `touching_road1_direction_to` tinyint(1),					# 接道方向1,
  `touching_road1_width` double,							# 接道幅員1,
  `touching_road2_type` tinyint(1),							# 接道種別2,
  `touching_road2_touching_side` tinyint(1),				# 接道接面2,
  `touching_road2_positional_specification` tinyint(1),		# 接道位置指定2,
  `touching_road2_direction_to` tinyint(1),					# 接道方向2,
  `touching_road2_width` double,							# 接道幅員2,
  `touching_road3_type` tinyint(1),							# 接道種別3,
  `touching_road3_touching_side` tinyint(1),				# 接道接面3,
  `touching_road3_positional_specification` tinyint(1),		# 接道位置指定3,
  `touching_road3_direction_to` tinyint(1),					# 接道方向3,
  `touching_road3_width` double,							# 接道幅員3,
  `touching_road4_type` tinyint(1),							# 接道種別4,
  `touching_road4_touching_side` tinyint(1),				# 接道接面4,
  `touching_road4_positional_specification` tinyint(1),		# 接道位置指定4,
  `touching_road4_direction_to` tinyint(1),					# 接道方向4,
  `touching_road4_width` double,							# 接道幅員4,
  `touching_road_pavement` tinyint(1),						# 接道舗装,
  `room_layout_type` tinyint(1),							# 間取タイプ（1）,
  `number_of_rooms` tinyint(1),								# 間取部屋数（1）,
  `room_position` tinyint(1),								# 部屋位置,
  `number_of_closets` tinyint(1),							# 納戸数,
  `room1_floor_number` tinyint(1),							# 室所在階1,
  `room1_type` tinyint(1),									# 室タイプ1,
  `room1_area` double,										# 室広さ1,
  `room1_number_of_rooms` tinyint(1),						# 室数1,
  `room2_floor_number` tinyint(1),							# 室所在階2,
  `room2_type` tinyint(1),									# 室タイプ2,
  `room2_area` double,										# 室広さ2,
  `room2_number_of_rooms` tinyint(1),						# 室数2,
  `room3_floor_number` tinyint(1),							# 室所在階3,
  `room3_type` tinyint(1),									# 室タイプ3,
  `room3_area` double,										# 室広さ3,
  `room3_number_of_rooms` tinyint(1),						# 室数3,
  `room4_floor_number` tinyint(1),							# 室所在階4,
  `room4_type` tinyint(1),									# 室タイプ4,
  `room4_area` double,										# 室広さ4,
  `room4_number_of_rooms` tinyint(1),						# 室数4,
  `room5_floor_number` tinyint(1),							# 室所在階5,
  `room5_type` tinyint(1),									# 室タイプ5,
  `room5_area` double,										# 室広さ5,
  `room5_number_of_rooms` tinyint(1),						# 室数5,
  `room6_floor_number` tinyint(1),							# 室所在階6,
  `room6_type` tinyint(1),									# 室タイプ6,
  `room6_area` double,										# 室広さ6,
  `room6_number_of_rooms` tinyint(1),						# 室数6,
  `room7_floor_number` tinyint(1),							# 室所在階7,
  `room7_type` tinyint(1),									# 室タイプ7,
  `room7_area` double,										# 室広さ7,
  `room7_number_of_rooms` tinyint(1),						# 室数7,
  `room_others` text,										# 間取りその他,
  `parking_lot_existence` tinyint(1),						# 駐車場在否,
  `parking_lot_monthly_fee` double,							# 駐車場月額,
  `parking_lot_monthly_fee_tax` double,						# 駐車場月額消費税,
  `parking_lot_deposit` double,								# 駐車場敷金（額）,
  `parking_lot_deposit_month` tinyint(1),					# 駐車場敷金（ヶ月）,
  `Parking_lot_fee` double,									# 駐車場礼金（額）,
  `Parking_lot_fee_month` tinyint(1),						# 駐車場礼金（ヶ月）,
  `building_structure` tinyint(1),							# 建物構造,
  `building_industrial_method` tinyint(1),					# 建物工法,
  `building_form` tinyint(1),								# 建物形式,
  `ground_hierarchy` tinyint(1),							# 地上階層,
  `underground_hierarchy` tinyint(1),						# 地下階層,
  `whereabouts_floor` tinyint(1),							# 所在階,
  `constructed_date` int,									# 築年月（西暦）,
  `total_number_of_houses` int,								# 総戸数,
  `total_number_of_houses_of_building` int,					# 棟総戸数,
  `number_of_houses_of_ream_building` int,					# 連棟戸数,
  `direction_of_balcony` tinyint(1),						# バルコニー方向（1）,
  `rebuilding1_date` date,									# 増改築年月1,
  `rebuilding1_history` text,								# 増改築履歴1,
  `rebuilding2_date` date,									# 増改築年月2,
  `rebuilding2_history` text,								# 増改築履歴2,
  `rebuilding3_date` date,									# 増改築年月3,
  `rebuilding3_history` text,								# 増改築履歴3,
  `surrounding1` text,										# 周辺環境1（フリー）,
  `surrounding1_distance` double,							# 距離1,
  `surrounding1_take_to` int,								# 時間1,
  `surrounding1_number` int,								# 周辺アクセス１,
  `remarks1` text,											# 備考1,
  `remarks2` text, 											# 備考2,
  `memo` text,												# 自社管理欄,
  `no_rebuild_flag` tinyint(1),								# 再建築不可フラグ
  `formatted_address` text,									# google住所検索用アドレス
  KEY (property_id),
  KEY (data_id),
  KEY (type_id),
  KEY (land_id),
  PRIMARY KEY (id)
) TYPE=MyISAM;


CREATE TABLE realty_rent (
  `id` bigint AUTO_INCREMENT,								# id
  `property_id` bigint,										# 物件番号
  `data_id` tinyint(1),										# データ種類
  `type_id` tinyint(1),										# 物件種別(土地、戸建、マン[マンション等]、外全[住宅以外の建物全部]、外一[住宅以外の建物一部]、居住[賃貸居住用]、事業[賃貸事業用]）
  `land_id` tinyint(1),										# 物件種目（売地、借地権、底地権）
  `member_name` text,										# 会員名,
  `member_phone` varchar(12),								# 代表電話番号,
  `contact_person` varchar(32),								# 問合せ担当者（1）,
  `contact_phone` varchar(12),								# 問合せ電話番号（1）,
  `contact_email` varchar(64),								# Eメールアドレス（1）,
  `drawing` tinyint(1),										# 図面,
  `created` date,											# 登録年月日,
  `updated` date,											# 変更年月日,
  `prefecture` varchar(8),									# 都道府県名,
  `county` varchar(16) ,									# 所在地名1,市区
  `township` varchar(32) ,									# 所在地名2,町村
  `address1` text ,											# 所在地名3,番地
  `address2` text ,											# 建物名
  `address3` text ,											# 部屋番号,
  `railline_name` text ,									# 沿線略称（1）,
  `station_name` text ,										# 駅名（1）,
  `twf_station` tinyint ,									# 徒歩（分）1（1）,
  `dnf_station` tinyint ,									# 徒歩（m）2（1）,
  `tbf_station` tinyint ,									# バス（1）,
  `busline_name` text ,										# バス路線名（1）,
  `busstop_name` text ,										# バス停名称（1）,
  `twf_bustop` tinyint(1)  ,								# 停歩（分）（1）,
  `dnf_bustop` tinyint(1)  ,								# 停歩（m）（1）,
  `tcf_station` tinyint(1)  ,								# 車（km）（1）,
  `other_transit` text ,									# その他交通手段,
  `twf_other` tinyint(1)  ,									# 交通（分）1,
  `dnf_other` tinyint(1)  ,									# 交通（m）2,
  `inspection_rate` tinyint(1)  ,							# 現況,検査
  `movingin_term` tinyint(1)  ,								# 入居時期,
  `movingin_ym` char(6)  ,									# 入居年月（西暦）,
  `movingin_day` tinyint(1),								# 入居日,
  `movingin_bme` tinyint(1)  ,								# 引渡旬,
  `dealings_mode` tinyint(1),								# 取引態様,（専属・専任・一般・他）
  `price` double,											# 賃料,
  `tsubo_unitprice` double,									# 坪単価,
  `squaremeter_unitprice` double,							# ㎡単価,
  `guarantee_deposit` double,								# 保証金1（額）				
  `guarantee_deposit_month` tinyint(1),						# 保証金2（ヶ月）			
  `beneficial_payment` double,								# 礼金1（額）				
  `beneficial_payment_month`  tinyint(1),					# 礼金2（ヶ月）				
  `depositcaution_money` double,							# 敷金1（額）				
  `depositcaution_month`  tinyint(1),						# 敷金2（ヶ月）				
  `contract_term`  int,										# 契約期間					
  `area_of_floor` double,									# 使用部分面積         		
  `area_of_terrace` double,									# バルコニー（テラス）面積,
  `area_of_private_garden` double,							# 専用庭面積,
  `maintenance_fee` double,									# 管理費,
  `management_union_existence` tinyint(1),					# 管理組合有無,
  `common_service_charge` double,							# 共益費					
  `incidental_expenses` double,								# 雑費						
  `renewal_type`  tinyint(1),								# 更新区分					
  `renewal_fee` double,										# 更新料（額）				
  `renewal_fee_month`  tinyint(1),							# 更新料（ヶ月）			
  `insurance_entry_obligation`  tinyint(1),					# 保険加入義務				
  `insurance_name` double,									# 保険名称					
  `insurance_charge` double,								# 保険料					
  `insurance_term` int,										# 保険期間					
  `room_layout_type` tinyint(1),							# 間取タイプ（1）,
  `number_of_rooms` tinyint(1),								# 間取部屋数（1）,
  `room_position` tinyint(1),								# 部屋位置,
  `number_of_closets` tinyint(1),							# 納戸数,
  `room_others` text,										# 間取りその他,
  `parking_lot_existence` tinyint(1),						# 駐車場在否,
  `parking_lot_monthly_fee` double,							# 駐車場月額,
  `parking_lot_deposit_month` tinyint(1),					# 駐車場敷金（ヶ月）,
  `Parking_lot_fee_month` tinyint(1),						# 駐車場礼金（ヶ月）,
  `building_structure` tinyint(1),							# 建物構造,
  `ground_hierarchy` tinyint(1),							# 地上階層,
  `underground_hierarchy` tinyint(1),						# 地下階層,
  `whereabouts_floor` tinyint(1),							# 所在階,
  `constructed_date` int,									# 築年月（西暦）,
  `builtnew_flag` tinyint(1),								# 新築フラグ				
  `direction_of_balcony` tinyint(1),						# バルコニー方向（1）,
  `surrounding1` text,										# 周辺環境1（フリー）,
  `surrounding1_distance` double,							# 距離1,
  `surrounding1_take_to` int,								# 時間1,
  `surrounding1_number` int,								# 周辺アクセス１,
  `remarks1` text,											# 備考1,
  `remarks2` text, 											# 備考2,
  `memo` text,												# 自社管理欄,
  `formatted_address` text,									# google住所検索用アドレス
  KEY (property_id),
  KEY (data_id),
  KEY (type_id),
  KEY (land_id),
  PRIMARY KEY (id)
) TYPE=MyISAM;
##
## Data from http://www.ekidata.jp
##
CREATE TABLE realty_stations (
	rr_cd 			tinyint(2), 		## ○ 	鉄道概要コード 	鉄道会社概要コード
	line_cd 		mediumint(5),	 	## ○ 	路線コード 		鉄道コード + エリアコード + 連番 ※大手私鉄のみエリアコード = 0
	station_cd 		int(7), 			## ○ 	駅コード 		路線コード + 連番
	line_sort 		mediumint(5), 		## - 	路線並び順 		新路線追加時等に調整
	station_sort 	int(7), 			## - 	駅並び順 		新駅追加時等に調整
 	station_g_cd 	int(7), 			## ○ 	駅グループコード複数路線駅をコードで統一
	r_type 			tinyint(1),	 		## ○ 	駅タイプ 		１：通常駅　2：地下鉄駅
	rr_name 		char(64), 			## ○ 	鉄道概要名 		JR/大手私鉄/その他
	line_name 		char(128),	 		## ○ 	路線名 			路線名称
	station_name 	char(128),	 		## ○ 	駅名 			駅名称
	pref_cd 		tinyint(2),	 		## ○ 	都道府県コード 	北海道～沖縄＋その他
	lon 			double,		 		## - 	経度 			小数点含む [ 世界測地系(WGS84) ]
	lat 			double,				## - 	緯度 			小数点含む [ 世界測地系(WGS84) ]
	f_flag 			tinyint(1),			## ○ 	表示フラグ 		０：非表示　１：表示
	KEY (station_name),
	PRIMARY KEY (station_cd)
) TYPE=MyISAM;
