<?php
//  ------------------------------------------------------------------------ //
//                XOOPS Cube Realty - Realty Management System               //
//                    Copyright (c) 2011 Bluemoon inc.                       //
//               auther Yoshi Sakai <http://www.bluemooninc.jp/>             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
/******************************************************************************
 * start control
 */
require('../../mainfile.php');
include(XOOPS_ROOT_PATH.'/header.php');
include XOOPS_ROOT_PATH.'/class/pagenav.php';
include('./class/model_realty.class.php');
include('./class/model_stations.class.php');
include_once('./include/mb_functions.php');

/******************************************************************************
 * $_GET parameter
 */

if (isset($_GET['realty_switch'])){
	$_SESSION['realty_switch']= intval($_GET['realty_switch']);
	//echo $_SESSION['realty_switch']; die;
}
$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
$search_typeid = isset($_GET['search_typeid']) ? intval($_GET['search_typeid']) : NULL;
$search_railline = isset($_GET['search_railline']) ? htmlspecialchars($_GET['search_railline'], ENT_QUOTES) : NULL;
$search_station_from = isset($_GET['search_station_from']) ? htmlspecialchars($_GET['search_station_from'], ENT_QUOTES) : NULL;
$search_station_to = isset($_GET['search_station_to']) ? htmlspecialchars($_GET['search_station_to'], ENT_QUOTES) : NULL;
$search_price_low = isset($_GET['search_price_low']) ? intval($_GET['search_price_low']) : NULL;
$search_price_high = isset($_GET['search_price_high']) ? intval($_GET['search_price_high']) : NULL;
$search_area_building = isset($_GET['search_area_building']) ? intval($_GET['search_area_building']) : NULL;
$search_area_land = isset($_GET['search_area_land']) ? intval($_GET['search_area_land']) : NULL;
$search_yearperiod = isset($_GET['search_yearperiod']) ? intval($_GET['search_yearperiod']) : NULL;
$search_walkto = isset($_GET['search_walkto']) ? intval($_GET['search_walkto']) : NULL;
$search_address = isset($_GET['search_address']) ? htmlspecialchars($_GET['search_address'], ENT_QUOTES) : NULL;
$search_order = isset($_GET['search_order']) ? intval($_GET['search_order']) : NULL;
$property_id = isset($_GET['property_id']) ? htmlspecialchars($_GET['property_id'], ENT_QUOTES) : NULL;
$id = isset($_GET['id']) ? htmlspecialchars($_GET['id'], ENT_QUOTES) : NULL;
$search_address = convert_mb_url($search_address); 
$search_railline = convert_mb_url($search_railline); 
$search_station_from = convert_mb_url($search_station_from); 
$search_station_to = convert_mb_url($search_station_to); 
$listno = isset($_GET['listno']) ? intval($_GET['listno']) : 0;

/******************************************************************************
 * Data loading from model class
 */
$searchArray=array();
switch($listno){
	case 0:
		$tblname = $_SESSION['realty_switch']==0 ? "realty_sale" : "realty_rent" ;
		$listTitle = _RE_REALTY_ALLLIST;
		$tblno = 0;
		break;
	case 1:
		$tblname = "realty_detail";
		$listTitle = _RE_REALTY_RECOMMENDS;
		$tblno = 1;
		break;
	case 2:
		$tblname = $_SESSION['realty_switch']==0 ? "realty_sale" : "realty_rent" ;
		$listTitle = _RE_REALTY_NEWARRIVAL;
		$tblno = 0;
		$search_order = 8;
		$searchArray[] = " updated>=NOW()-interval ". $xoopsModuleConfig['new_arrival_days'] . " day "; 
		break;
	case 3:
		$tblname = $_SESSION['realty_switch']==0 ? "realty_sale" : "realty_rent" ;
		$listTitle = _RE_REALTY_NEWBUILD;
		$tblno = 0;
		$search_yearperiod = 1;
		$search_order = 8;
		//$searchArray[] = " updated>=NOW()-interval ". $xoopsModuleConfig['new_arrival_days'] . " day "; 
		$searchArray[] = " constructed_date >= " . (date("Y")-1)*100 + date("m") . " ";
		break;
	case 4:
		$tblname = "realty_detail";
		$listTitle = _RE_REALTY_PROMPT_REPORT;
		$tblno = 1;
		$searchArray[] = " property_id=0 ";
		$property_id = NULL;
		break;
}
$realty_data = new model_realty($tblname,$start,$xoopsModuleConfig['per_page']);
if ($search_typeid    ) $searchArray[] = " type_id=" . $search_typeid . " ";
if ($search_railline ) $searchArray[] = " (r.railline_name like '%". $search_railline ."%') ";
if ($search_station_from && $search_station_to){
	$realty_stations = new model_stations("realty_stations",$search_railline,$search_station_from,$search_station_to);
	$searchArray[] = " (r.station_name IN ( " . $realty_stations->station_names ."))";
}elseif ($search_station_from && !$search_station_to)
	$searchArray[] = " r.station_name='$search_station_from' ";  
elseif (!$search_station_from && $search_station_to)
	$searchArray[] = " r.station_name='$search_station_to' ";
if($_SESSION['realty_switch']==1){
	if ($search_price_low ) $searchArray[] = " r.price >= " . $search_price_low . " " ;
	if ($search_price_high) $searchArray[] = " r.price <= " . $search_price_high . " ";
}else{
	if ($search_price_low ) $searchArray[] = " r.price >= " . $search_price_low . "0000 " ;
	if ($search_price_high) $searchArray[] = " r.price <= " . $search_price_high . "0000 ";
}
if ($search_area_building  ) $searchArray[] = " area_of_building >= " . $search_area_building . " " ;
if ($search_area_land ) $searchArray[] = " area_of_building => " . $search_area_land . " ";
if ($search_yearperiod ) $searchArray[] = " constructed_date >= " . date("Ym",mktime(0, 0, 0, date("m"),   date("d"),   date("Y") - $search_yearperiod) );
if ($search_walkto    ) $searchArray[] = " r.twf_station<=" . $search_walkto . " ";
$realty_data->where_array_and = $searchArray;
$searchArray=array();
if ($search_address ) $searchArray[] = " (formatted_address like '%". $search_address ."%') ";
$realty_data->where_array_or = $searchArray;
switch($search_order){
	case 0:	$realty_data->sortname="price"; $realty_data->sortorder="ASC"; break;
	case 1:	$realty_data->sortname="price";	$realty_data->sortorder="DESC";	break;
	case 2:	$realty_data->sortname="area_of_building"; $realty_data->sortorder="ASC"; break;
	case 3:	$realty_data->sortname="area_of_building";	$realty_data->sortorder="DESC";	break;
	case 4:	$realty_data->sortname="constructed_date"; $realty_data->sortorder="ASC"; break;
	case 5:	$realty_data->sortname="constructed_date";	$realty_data->sortorder="DESC";	break;
	case 6:	$realty_data->sortname="twf_station"; $realty_data->sortorder="ASC"; break;
	case 7:	$realty_data->sortname="twf_station";	$realty_data->sortorder="DESC";	break;
	case 8:	$realty_data->sortname="updated";	$realty_data->sortorder="DESC";	break;
}

$realty_data->getDataRecords($tblno,$property_id,$id);

/******************************************************************************
 * assign to view class
 */
$xoopsTpl->assign("listTitle",$listTitle);
$xoopsTpl->assign("realty_data" , $realty_data->data_records);

//Page Navi
$optparam = $realty_data->sortname ? 'sortname='.$realty_data->sortname : "";
if ($listno					) $optparam .= "&amp;listno="           	.$listno;
if ($search_typeid			) $optparam .= "&amp;search_typeid="    	.$search_typeid;
if (strlen($search_railline)>0		) $optparam .= "&amp;search_railline=" 		.$search_railline;
if (strlen($search_station_from)>0	) $optparam .= "&amp;search_station_from=" 	.$search_station_from;
if (strlen($search_station_to)>0	) $optparam .= "&amp;search_station_to=" 	.$search_station_to;
if ($search_price_low		) $optparam .= "&amp;search_price_low=" 	.$search_price_low;
if ($search_price_high		) $optparam .= "&amp;search_price_high="	.$search_price_high;
if ($search_area_building	) $optparam .= "&amp;search_area_building=" .$search_area_building;
if ($search_area_land		) $optparam .= "&amp;search_area_land=" 	.$search_area_land; 
if ($search_yearperiod		) $optparam .= "&amp;search_yearperiod=" 	.$search_yearperiod;
if (!is_null($search_walkto)) $optparam .= "&amp;search_walkto="    	.$search_walkto;
if (strlen($search_address)>0) $optparam .= "&amp;search_address=" 		.$search_address;
if ($search_order			) $optparam .= "&amp;search_order="     	.$search_order;

$nav = new XoopsPageNav($realty_data->data_count,$realty_data->parPage,$realty_data->start,"start",$optparam );
//echo "Count:".$realty_data->data_count."&nbsp;Per Page:".$realty_data->parPage."&nbsp;Start:".$realty_data->start."&nbsp;Option:",$optparam; die;

//$xoopsTpl->assign('warrning', $realty_data->sql);
$xoopsTpl->assign('realty_pagenav'   ,$nav->renderNav(4));
$xoopsTpl->assign('listno'           ,$listno);
$xoopsTpl->assign('search_typeid'    ,$search_typeid);
$xoopsTpl->assign('search_railline' ,$search_railline);
$xoopsTpl->assign('search_station_from' ,$search_station_from);
$xoopsTpl->assign('search_station_to' ,$search_station_to);
$xoopsTpl->assign('search_price_low' ,$search_price_low);
$xoopsTpl->assign('search_price_high',$search_price_high);
$xoopsTpl->assign('search_area_building'  ,$search_area_building);
$xoopsTpl->assign('search_area_land' ,$search_area_land);
$xoopsTpl->assign('search_yearperiod' ,$search_yearperiod);
$xoopsTpl->assign('search_walkto'    ,$search_walkto);
$xoopsTpl->assign('search_address' ,$search_address);
$xoopsTpl->assign('search_order'     ,$search_order);

if ($xoopsUser){
	if ($listno==1) $xoopsTpl->assign( 'addnew_link' , "edit.php?property_id=$property_id&amp;op=addnew" ) ;
	if ($listno==4) $xoopsTpl->assign( 'addnew_link' , "edit.php?op=addnew" ) ;
}

if (!is_null($property_id) || !is_null($id)){
	$detail = $realty_data->getDetailRecord("realty_detail",$property_id,$id);
	$xoopsTpl->assign("realty_detail" , $detail);
	if (is_object($xoopsUser)){
		if( is_null($detail) )
			$xoopsTpl->assign( 'addnew_link' , "edit.php?property_id=$property_id&amp;op=addnew" ) ;
		else{
			$xoopsTpl->assign( 'edit_link' , "edit.php?id=$id&amp;op=edit" ) ;
		}
	}
	$xoopsOption['template_main'] = 'realty_detail.html';
}else{
	$xoopsOption['template_main'] = 'realty_index.html';
}
$xoopsTpl->assign( 'sql' , $realty_data->sql );
$xoopsTpl->assign( 'xoops_module_header' , $realty_data->html_header . "\n" . $xoopsTpl->get_template_vars( "xoops_module_header" ) ) ;

include(XOOPS_ROOT_PATH.'/footer.php');
?>