<?php
/***************************************************************************
                            thumb.php  -  description
                           ---------------------------
    begin                : Wed Apr 21 2004
    copyleft             : (C) 2004 Bluemoon inc.
    home page            : http://www.bluemooninc.biz/
    auther               : Yoshi.Sakai
    email                : webmaster@bluemooninc.biz
    Memo                 : This is Thumbsnail function.
                         : It need to set the GD libraly option on PHP. (php.ini)
    Original source from : http://php.s3.to/ (Let's PHP!)

    $Id: thumb.php,v 1.1.1.1 2005/08/28 02:13:08 yoshis Exp $

 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/
/*
** Get image type with binary check
*/
function getimagetype($data){
    if (strncmp("\x00\x00\x01\x00", $data, 4) == 0) {
        return "ico";
    } else if (strncmp("\x89PNG\x0d\x0a\x1a\x0a", $data, 8) == 0) {
        return "png";
    } else if (strncmp('BM', $data, 2) == 0) {
        return "bmp";
    } else if (strncmp('GIF87a', $data, 6) == 0 || strncmp('GIF89a', $data, 6) == 0) {
        return "gif";
    } else if (strncmp("\xff\xd8", $data, 2) == 0) {
        return "jpg";
    } else {
        return false;
    }
}
/*
** Get upload file by Yoshi.Sakai, bluemooninc.biz 2004/3/14
*/
function get_uploadfile($prename=NULL) {
	global $xoopsUser,$BlogCNF,$_FILES;
	$fname = $prename;
	$upfile        = $_FILES['upfile'];
	$upfile_tmp    = $_FILES['upfile']['tmp_name'];	// Temp File name
	$upfile_size    = $_FILES['upfile']['size'];        // Size
	$upfile_type    = $_FILES['upfile']['type'];        // Type
	$info = pathinfo($_FILES['upfile']['name']);
	$ext =  "." . $info['extension'];

	if ($upfile_tmp != "" && is_object($xoopsUser)){
		// Disp File Infomation for debug
		/*
		print("File Infomation:<BR>\n");
		print("File From : $upfile_tmp<BR>\n");
		print("File To : $upfile_name<BR>\n");
		print("File Size - $upfile_size<BR>\n");
		print("File type - $upfile_type<BR>\n");
		*/
		if (eregi($BlogCNF['imgtype'], $upfile_type)){
			$size = getimagesize($upfile_tmp);
			$type = getimagetype($upfile_tmp);
			if ( !$size || !strcmp($type,$upfile_type) ) return NULL;
		}
		if (eregi($BlogCNF['imgtype'].'|'.$BlogCNF['embedtype'], $upfile_type)){
			$upfile_localname = $fname."_".time() . $ext;
			$upfile_path = XOOPS_ROOT_PATH.$BlogCNF['img_dir'].$upfile_localname;
			move_uploaded_file($upfile_tmp,$upfile_path);
			//chmod($upfile_path,0644);
			// Thumbs Support ( PHP GD Libraly Required )
			if (eregi($BlogCNF['thumb_ext'],strtolower($upfile_localname))) {
				if ($size[0] > $BlogCNF['w'] || $size[1] > $BlogCNF['h']) {
					$thumb_localname = thumb_create($upfile_path,$BlogCNF['w'],$BlogCNF['h'],XOOPS_ROOT_PATH.$BlogCNF['thumb_dir']);
				}
			}
		}
	}
	return $upfile_localname;
}

function thumb_create($src, $W, $H, $thumb_dir="./"){
	$gd_ver=2;					// By Yoshi.S
	
  // Get witdh,Height and type
  $size = GetImageSize($src);
  switch ($size[2]) {
    case 1 : $im_in = @ImageCreateFromGif($src); break;
    case 2 : $im_in = @ImageCreateFromJPEG($src); break;
    case 3 : $im_in = @ImageCreateFromPNG($src);  break;
  }
  if (!$im_in) die(_NW_NOGDLIB);	// By Yoshi.S
  // Resize
  if ($size[0] > $W || $size[1] > $H) {
    $key_w = $W / $size[0];
    $key_h = $H / $size[1];
    ($key_w < $key_h) ? $keys = $key_w : $keys = $key_h;
    $out_w = $size[0] * $keys;
    $out_h = $size[1] * $keys;
  } else {
    $out_w = $size[0];
    $out_h = $size[1];
  }
  if ($gd_ver == 2){
	  // Make thumbsnail image from original (for GD2.0)
	  $im_out = ImageCreateTrueColor($out_w, $out_h);
	  $resize = ImageCopyResampled($im_out, $im_in, 0, 0, 0, 0, $out_w, $out_h, $size[0], $size[1]);
	} else {
	  // (for under GD2.0)
	  $im_out = ImageCreate($out_w, $out_h);
	  ImageCopyResized($im_out, $im_in, 0, 0, 0, 0, $out_w, $out_h, $size[0], $size[1]);
	}
  // Oputput thumbsnail to folder
  $filename = substr($src, strrpos($src,"/")+1);
  if ($size[2]!=2){
  	$filename = substr($filename, 0, strrpos($filename,"."));
  	$filename = $filename.".jpg";
  }
  touch($thumb_dir.$filename);
  ImageJPEG($im_out, $thumb_dir.$filename);
  //ImagePNG($im_out, $thumb_dir.$filename.".png");
  // Delete images
  ImageDestroy($im_in);
  ImageDestroy($im_out);
  return $filename;
}
?>