<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
// Author: Tobias Liegl (AKA CHAPI)                                          //
// Site: http://www.chapi.de                                                 //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
// Hacker: GIJ=CHECKMATE (AKA GIJOE)                                         //
// Site: http://www.peak.ne.jp/xoops/                                        //
// ------------------------------------------------------------------------- //

include( '../../mainfile.php' ) ;

if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

include_once( 'class/model_detail.class.php' ) ;
include_once( 'class/xPage.textsanitizer.php' ) ;
include_once( 'include/render_function.inc.php' ) ;
include_once( 'include/constants.inc.php' ) ;
include_once( 'include/gtickets.php' );

require_once( XOOPS_ROOT_PATH.'/class/template.php' ) ;

// $myts
$myts =& MyTextSanitizer::getInstance() ;

// for "Duplicatable"
$mydirname = basename( dirname( __FILE__ ) ) ;
if( ! preg_match( '/^(\D+)(\d*)$/' , $mydirname , $regs ) ) 
	echo ( "invalid dirname: " . htmlspecialchars( $mydirname ) ) ;
$mydirnumber = $regs[2] === '' ? '' : intval( $regs[2] ) ;
$mod_url = XOOPS_URL."/modules/$mydirname" ;

// utility variables
$mymodpath = XOOPS_ROOT_PATH."/modules/$mydirname" ;
$mytablename = $xoopsDB->prefix( "realty_detail" ) ;


if( !$xoopsUser->isAdmin() ){
	redirect_header(XOOPS_URL, 2, _NOPERM);
}
/*
 * initial parameter for addnew
 */
$id = null;
$visible = $nobreaks = $nosmiley = $submenu = 1;
$nocomments = 0;

// check if $_GET['id'] is specified
$property_id = empty( $_GET['property_id'] ) ? NULL : htmlspecialchars( $_GET['property_id'] , ENT_QUOTES);
$property_id = isset($_POST['property_id']) ? htmlspecialchars($_POST['property_id'], ENT_QUOTES) : $property_id;
$id = empty( $_GET['id'] ) ? NULL : htmlspecialchars( $_GET['id'] , ENT_QUOTES);
$id = isset($_POST['id']) ? htmlspecialchars($_POST['id'], ENT_QUOTES) : $id;

$op = isset($_GET['op']) ? htmlspecialchars($_GET['op'], ENT_QUOTES) : '';
$op = isset($_POST['op']) ? htmlspecialchars($_POST['op'], ENT_QUOTES) : $op;
$title = null;
$message = null;
$recommends = null;
$nohtml = null;
$address = null;
$last_modified = null;
$created = null;
$html_header = null;
$railline_name = null;
$station_name = null;
$twf_station = null;
$layout_desc = null;
$price = null;

$text = null;
$nohtml = null;
$tb = new model_detail($mytablename);

if ($op=="editit"){
	// Ticket Check
	if ( ! $xoopsGTicket->check( true , $mydirname ) ) {
		redirect_header(XOOPS_URL.'/',3,$xoopsGTicket->getErrors());
	}
	$ret = $tb->post2table($mytablename,$id);
	if( $ret==false ) die ( _TC_ERRORINSERT ) ;
	if( is_null($id) ) $id = $tb->new_id();
} elseif( !$op )  {
	redirect_header( XOOPS_URL.'/' , 2 , _TC_FILENOTFOUND ) ;
	exit ;
}
if( $id && $op!="addnew" )  {
	extract( $tb->getById($id) ) ;
}
if( $property_id && $op=="addnew" )  {
	$tblname = $_SESSION['realty_switch']==0 ? "realty_sale" : "realty_rent" ;
	extract( $tb->getByPropertyId($property_id,$xoopsDB->prefix('$tblname')) ) ;
	$id = NULL;
	$price /= 10000;
	$address = $prefecture.$county.$township.$address1;
	$layout_type = explode("|",_RE_LAYOUTDESC);
	$layout_desc = $number_of_rooms . strtoupper($layout_type[$room_layout_type]);
}
$comments = $nocomments == 1 ? 0 : 1;

// header part
header( 'Content-Type:text/html; charset='._CHARSET ) ;
$tpl = new XoopsTpl();
$tpl->xoops_setTemplateDir(XOOPS_ROOT_PATH.'/themes');
$tpl->xoops_setCaching(2);
$tpl->xoops_setCacheTime(0);

$tpl->assign('charset', _CHARSET);
$tpl->assign('sitename', $xoopsConfig['sitename']);
$tpl->assign('site_url', XOOPS_URL);
$tpl->assign('content_url', XOOPS_URL."/modules/$mydirname/index.php?id=$id");
$tpl->assign('lang_contentfrom', _TC_URLFORSTORY);
$myts =& MyTextSanitizer::getInstance() ;
$tpl->assign( 'id' ,  $id ) ;
$tpl->assign( 'property_id', $property_id ) ;
$tpl->assign( 'title' , $myts->makeTboxData4Show( $title ) ) ;
$tpl->assign( 'visible', $visible);
$tpl->assign( 'recommends', $recommends);
$tpl->assign( 'nohtml', $nohtml);
$tpl->assign( 'nosmiley', $nosmiley);
$tpl->assign( 'nobreaks', $nobreaks);
$tpl->assign( 'comments', $comments);

$tpl->assign( 'address', $address);
$tpl->assign( 'submenu', $submenu);
$tpl->assign( 'last_modified' , $last_modified  ) ;
$tpl->assign( 'created' ,  $created ) ;
$tpl->assign( 'html_header' , $myts->makeTboxData4Show( $html_header ) ) ;
$tpl->assign( 'created' ,  $created ) ;
$tpl->assign( 'railline' , $myts->makeTboxData4Show( $railline_name ) ) ;
$tpl->assign( 'station' , $myts->makeTboxData4Show( $station_name ) ) ;
$tpl->assign( 'takewalk' ,  $twf_station ) ;
$tpl->assign( 'layout_desc' ,  $layout_desc ) ;
$tpl->assign( 'price' ,  $price ) ;

$tpl->assign( 'modulename' , $xoopsModule->getVar('name') ) ;
$tpl->assign( 'mod_url' , $mod_url );
$tpl->assign( 'gticket' , 
	$xoopsGTicket->getTicketHtml( __LINE__ , 1800 , $mydirname ) );


// getting "content"

	$content = detail_content_render( $text , $nohtml , $nosmiley , $nobreaks ,  $xoopsModuleConfig['detail_space2nbsp'] ) ;

// convert from {X_SITEURL} to XOOPS_URL
$content = str_replace( '{X_SITEURL}' , XOOPS_URL , $content ) ;

$tpl->assign( 'content' , $content ) ;

$main_template = empty( $xPage_singlecontent ) ? "db:realty_edit.html" : "db:realty_index.html" ;

$tpl->display( $main_template ) ;

?>