<?php
//  ------------------------------------------------------------------------ //
//                XOOPS Cube Realty - Realty Management System               //
//                    Copyright (c) 2011 Bluemoon inc.                       //
//               auther Yoshi Sakai <http://www.bluemooninc.jp/>             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
/******************************************************************************
 * start control
 */
require('../../mainfile.php');
include(XOOPS_ROOT_PATH.'/header.php');
include XOOPS_ROOT_PATH.'/class/pagenav.php';
include('./class/model_realty.class.php');
include_once('./include/mb_functions.php');

/******************************************************************************
 * $_GET parameter
 */
$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
$search_typeid = isset($_GET['search_typeid']) ? intval($_GET['search_typeid']) : NULL;
$search_price_low = isset($_GET['search_price_low']) ? intval($_GET['search_price_low']) : NULL;
$search_price_high = isset($_GET['search_price_high']) ? intval($_GET['search_price_high']) : NULL;
$search_area_building = isset($_GET['search_area_building']) ? intval($_GET['search_area_building']) : NULL;
$search_area_land = isset($_GET['search_area_land']) ? intval($_GET['search_area_land']) : NULL;
$search_yearperiod = isset($_GET['search_yearperiod']) ? intval($_GET['search_yearperiod']) : NULL;
$search_walkto = isset($_GET['search_walkto']) ? intval($_GET['search_walkto']) : NULL;
$search_address = isset($_GET['search_address']) ? htmlspecialchars($_GET['search_address'], ENT_QUOTES) : NULL;
$search_order = isset($_GET['search_order']) ? intval($_GET['search_order']) : NULL;
$property_id = isset($_GET['property_id']) ? htmlspecialchars($_GET['property_id'], ENT_QUOTES) : NULL;
$id = isset($_GET['id']) ? htmlspecialchars($_GET['id'], ENT_QUOTES) : NULL;
$search_address = convert_mb_url($search_address);

/******************************************************************************
 * 
 * Data loading from model class
 */
$realty_data = new model_realty("realty_detail",$start,$xoopsModuleConfig['per_page']);
$searchArray=array();
if ($search_typeid    ) $searchArray[] = " type_id=" . $search_typeid . " ";
if ($search_price_low ) $searchArray[] = " price >= " . $search_price_low . "0000 " ;
if ($search_price_high) $searchArray[] = " price <= " . $search_price_high . "0000 ";
if ($search_area_building  ) $searchArray[] = " area_of_building >= " . $search_area_building . " " ;
if ($search_area_land ) $searchArray[] = " area_of_building <= " . $search_area_land . " ";
if ($search_yearperiod ) $searchArray[] = " constructed_date >= " . date("Y-m-d",mktime(0, 0, 0, date("m"),   date("d"),   date("Y")+$search_yearperiod) );
if ($search_walkto    ) $searchArray[] = " twf_station<=" . $search_walkto . " ";
$realty_data->where_array_and = $searchArray;
$searchArray=array();
if ($search_address ) $searchArray[] = " (formatted_address like '%". $search_address ."%') ";
if ($search_address ) $searchArray[] = " (railline_name like '%". $search_address ."%') ";
if ($search_address ) $searchArray[] = " (station_name like '%". $search_address ."%') ";
$realty_data->where_array_or = $searchArray;
switch($search_order){
	case 0:	$realty_data->sortname="price"; $realty_data->sortorder="ASC"; break;
	case 1:	$realty_data->sortname="price";	$realty_data->sortorder="DESC";	break;
	case 2:	$realty_data->sortname="area_of_building"; $realty_data->sortorder="ASC"; break;
	case 3:	$realty_data->sortname="area_of_building";	$realty_data->sortorder="DESC";	break;
	case 4:	$realty_data->sortname="constructed_date"; $realty_data->sortorder="ASC"; break;
	case 5:	$realty_data->sortname="constructed_date";	$realty_data->sortorder="DESC";	break;
	case 6:	$realty_data->sortname="twf_station"; $realty_data->sortorder="ASC"; break;
	case 7:	$realty_data->sortname="twf_station";	$realty_data->sortorder="DESC";	break;
}
/******************************************************************************
 * assign to view class
 */


//Page Navi
$optparam = $realty_data->sortname ? 'sortname='.$realty_data->sortname : "";
if ($search_typeid    ) $optparam .= "&amp;search_typeid="    .$search_typeid;
if ($search_price_low ) $optparam .= "&amp;search_price_low=" .$search_price_low;
if ($search_price_high) $optparam .= "&amp;search_price_high=".$search_price_high;
if ($search_area_building  ) $optparam .= "&amp;search_area_building="  .$search_area_building;
if ($search_area_land ) $optparam .= "&amp;search_area_land=" .$search_area_land; 
if ($search_yearperiod ) $optparam .= "&amp;search_yearperiod=" .$search_yearperiod;
if ($search_walkto    ) $optparam .= "&amp;search_walkto="    .$search_walkto;
if ($search_address ) $optparam .= "&amp;search_address=" .$search_address;
if ($search_order     ) $optparam .= "&amp;search_order="     .$search_order;
$xoopsTpl->assign('search_typeid'    ,$search_typeid);
$xoopsTpl->assign('search_price_low' ,$search_price_low);
$xoopsTpl->assign('search_price_high',$search_price_high);
$xoopsTpl->assign('search_area_building'  ,$search_area_building);
$xoopsTpl->assign('search_area_land' ,$search_area_land);
$xoopsTpl->assign('search_yearperiod' ,$search_yearperiod);
$xoopsTpl->assign('search_walkto'    ,$search_walkto);
$xoopsTpl->assign('search_address' ,$search_address);
$xoopsTpl->assign('search_order'     ,$search_order);

if (is_object($xoopsUser)){
	$xoopsTpl->assign( 'addnew_link' , "edit.php?property_id=$property_id&amp;op=addnew" ) ;
}
//$xoopsTpl->assign('warrning', $realty_data->sql);
$realty_data->getDataRecords(1,$property_id,$id);
$xoopsTpl->assign("realty_data" , $realty_data->data_records);
if ( is_null($property_id) && is_null($id) ){
	$nav = new XoopsPageNav($realty_data->data_count,$realty_data->parPage,$realty_data->start,"start",$optparam );
	$xoopsTpl->assign('realty_pagenav'   ,$nav->renderNav(4));
	$xoopsOption['template_main'] = 'realty_detail_index.html';
}else{
	$xoopsOption['template_main'] = 'realty_detail.html';
}
$xoopsTpl->assign( 'xoops_module_header' , $realty_data->html_header . "\n" . $xoopsTpl->get_template_vars( "xoops_module_header" ) ) ;
include(XOOPS_ROOT_PATH.'/footer.php');
?>