<?php
// $Id: creditdata.class.php,v 1.44 2008/10/10 17:36:49 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                Credit management System                                   //
//                    Copyright (c) 2000 Bluemoon inc.                       //
//                       <http://www.bluemooninc.biz/>                       //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
/**
 * Real Class
 */
class model_mysql {
	var $tblname;
	var $id;
	var $sortname;
	var $sortorder;
	var $start=0;
	var $where_array_and = array();
	var $where_array_or = array();
	var $parPage=10;
	var $data_records=array();
	var $data_count=0;
	var $sql;
	var $property_id;
	var $detail;
	var $html_header;
	
	function model_mysql($tblname, $start=0 , $parPage=10, $sortname="updated", $sortorder="DESC"  ) {
		global $xoopsDB;
		$this->tblname = $xoopsDB->prefix($tblname);
		if ($sortname) $this->sortname=$sortname;
		if ($sortorder) $this->sortorder=$sortorder;
		if ($start) $this->start=$start;
		if ($parPage) $this->parPage=$parPage;
	}
	function getWhere($andor,$where_array){
		if( is_array($where_array) ){
			return implode($andor,$where_array);
		}
	}
	/**
	 * Get Image with their text
	 *
	 * @param   string  $text
	 * @return  string
	 **/
	function getImageURL( $text,$row ){
		$iResults = preg_match_all('/<img .*?src="(.*?)".*?>/i', $text, $matches);
		$imageURL = $matches[1][0];
    	return $imageURL;
	}
	function setIconImage( &$row ){
		if ( !isset($row['imageURL']) ){
    		switch($row['type_id']){
    			case 1:	
     				$row['icon'] = "land.png";
    				$row['imageURL'] = XOOPS_URL . "/modules/realty/images/" . $row['icon'];
    				break;
    			case 2:	
     				$row['icon'] = "house.png";
    				$row['imageURL'] = XOOPS_URL . "/modules/realty/images/" . $row['icon'];
    				$row['imageURL2'] = XOOPS_URL . "/modules/realty/images/" . strtolower($row['layout_desc']) . ".png";
    				break;
    			case 3:	
     				$row['icon'] = "condo.png";
    				$row['imageURL'] = XOOPS_URL . "/modules/realty/images/" . $row['icon'];
    				$row['imageURL2'] = XOOPS_URL . "/modules/realty/images/" . strtolower($row['layout_desc']) . ".png";
    				break;
    			case 4:	
     				$row['icon'] = "investment.png";
    				$row['imageURL'] = XOOPS_URL . "/modules/realty/images/" . $row['icon'];
    				break;
    		}
		}
    	return $row;
	}
	function makeRealtyRow($row,$type_desc,$layout_desc){
		$googlemap = $row['prefecture'].$row['county'].$row['township'].$row['address1'];
		$row['id'] = $row['detail_id'];
		$row['address'] = $googlemap;
     	$row['googlemap'] = urlencode(mb_convert_encoding($googlemap,"UTF-8","EUC-JP"));
     	$row['price_jp'] = (int)$row['price'] / 10000; 
     	$row['tsubo_jp'] = (int)$row['tsubo_unitprice'] / 10000; 
     	$row['constructed_year'] = intval($row['constructed_date']/100);
     	$row['constructed_month'] = $row['constructed_date'] - $row['constructed_year']*100;
     	$row['type_desc'] = $type_desc[$row['type_id']];
     	if ($row['number_of_rooms']){
     		$row['layout_desc'] = $row['number_of_rooms'] . strtoupper($layout_desc[$row['room_layout_type']]);
     		if ($row['constructed_year']) $row['yearsold'] = $row['constructed_year']<1900 ? _RE_YEARSNEW : sprintf( _RE_YEARSOLD , date("Y")-$row['constructed_year'] );
     	}
		$row['imageURL'] = $this->getImageURL($row['text'],$row['type_id']);
     	if (!$row['last_modified']) $row['last_modified'] = $row['updated'];
     	if ($row['twf_station']) $row['transit'] = _RE_WALKTO . $row['twf_station'] . _RE_MIN;
     	if ($row['tbf_station']) $row['transit'] = $row['busline_name'] . $row['busstop_name'] . _RE_WALKTO . $row['twf_bustop'] . _RE_MIN;
     	return $row;
	}
	function makeRealtyDetailRow($row){
		$row['imageURL'] = $this->getImageURL($row['text'],$row['type_id']);
     	$row['googlemap'] = urlencode(mb_convert_encoding($row['address'],"UTF-8","EUC-JP"));
     	$row['price_jp'] = $row['price']; 
     	return $row;
	}
	function getDataRecords($tblno=0,$property_id=NULL,$id=NULL){
		global $xoopsDB,$xoopsUser;
		/*
		 * make WHERE strings
		 */
		if (!is_null($property_id)){
			$this->property_id = $property_id;
			$wstr = " WHERE r.property_id=".$property_id;	
    		$this->sql = "SELECT r.*,d.id as detail_id,d.title, d.text FROM ".$this->tblname
	    	.' r LEFT JOIN '.$xoopsDB->prefix('realty_detail').' d ON r.property_id = d.property_id'
	    	. $wstr ;
		}elseif (!is_null($id)){
			$this->id = $id;
			$wstr = " WHERE id=".$id;	
    		$this->sql = "SELECT * FROM ".$this->tblname. $wstr ;
		}else{
			$wstr = '';
			if ($this->where_array_and || $this->where_array_or) $wstr = " WHERE ";	
			if ($this->where_array_and) $wstr .= $this->getWhere(" and ",$this->where_array_and);
			if ($this->where_array_and && $this->where_array_or) $wstr .= " AND (";	
			if ($this->where_array_or) $wstr .= $this->getWhere(" or ",$this->where_array_or) ;
			if ($this->where_array_and && $this->where_array_or) $wstr .= " )";	
			$sql = "SELECT COUNT(*) FROM ".$this->tblname . $wstr;
			$result = $xoopsDB->query($sql);
    		list($this->data_count) = $xoopsDB->fetchRow($result);
    		//$this->sql = "SELECT * FROM ".$this->tblname. $wstr 
    		//	. " ORDER BY " . $this->sortname . " " . $this->sortorder
    		//	. " LIMIT " . $this->start . "," . $this->parPage;
    		$this->sql = "SELECT r.*,d.id as detail_id,d.title, d.text FROM ".$this->tblname
	    	.' r LEFT JOIN '.$xoopsDB->prefix('realty_detail').' d ON r.property_id = d.property_id'
	    	. $wstr		
    		. " ORDER BY " . $this->sortname . " " . $this->sortorder
    		. " LIMIT " . $this->start . "," . $this->parPage;
		}
		//echo $this->sql; die;
      	$result = $xoopsDB->query($this->sql);
      	if (!$result) return NULL;
    	$type_desc = explode("|",_RE_TYPEDESC);
    	$layout_desc = explode("|",_RE_LAYOUTDESC);
    	$this->data_records = array();
    	while($row = $xoopsDB->fetchArray($result)) {  // PR[h̏擾
     		if ($tblno==0){
     			 $row = $this->makeRealtyRow($row,$type_desc,$layout_desc);
     		}else{
     			//$this->data_records[] = $row;
   				$row = $this->makeRealtyDetailRow($row);
     		}
     		$row=$this->setIconImage($row);
     		$this->data_records[] = $row;
     	}
     	//var_dump($this->data_records); die;
     	return $this->data_records;
	}
	function getDetailRecord($tblname,$property_id=NULL,$id=NULL){
		global $xoopsDB,$xoopsUser;
		$tblname = $xoopsDB->prefix($tblname);
		/*
		 * make WHERE strings
		 */
		$wstr = " WHERE ";
		if (!is_null($property_id)){
			$wstr .= "property_id=".$property_id;	
		}
		if (!is_null($property_id) && !is_null($id)){
			$wstr .= " AND ";	
		}
		if (!is_null($id)){
			$wstr .= "id=".$id;	
		}
		$this->property_id = $property_id;
		$this->id = $id;
		$this->sql = "SELECT * FROM ".$tblname. $wstr ;
		$result = $xoopsDB->query($this->sql);
      	if (!$result) return NULL;
     	while($row = $xoopsDB->fetchArray($result)) {  // PR[h̏擾      	
     		$this->detail = $row;
     		$this->html_header=$row['html_header'];
     	}
		return $this->detail;
	}
	function setSortname($sortname,$sortorder='ASC'){
		$this->sortname = $sortname;
		$this->sortorder = $sortorder;
	}
	/**
	 */
	function addImage( $tblname, $fname ) {
		global $xoopsDB;
		$tblname = $xoopsDB->prefix($tblname);
			
		$sql = sprintf("INSERT INTO %s ( property_id, filename) values ( '%s','%s');",
			$tblname,
			$this->property_id,
			$fname 
		);
		return $xoopsDB->queryF($sql);
	}
}
?>
