<?php
// $Id: realty_new.php,v 1.91 2009/01/05 16:43:54 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS Cube Realty - Realty Management System               //
//                    Copyright (c) 2010 Bluemoon inc.                       //
//                       <http://www.bluemooninc.jp/>                        //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

function realty_new_show($options){
	global $xoopsUser,$xoopsModuleConfig;
    $db =& Database::getInstance();
    $myts =& MyTextSanitizer::getInstance();
    $block = array();
    switch($options[2]) {
	    case 'homepage':
	        $order = 'last_modified';
    		$query = "SELECT r.*,d.title,d.text,d.last_modified FROM ".$db->prefix('realty')
    		.' r LEFT JOIN '.$db->prefix('realty_detail').' d ON r.property_id = d.property_id ';
    		$query .= " WHERE homepage='1' ORDER BY ".$order." DESC, updated DESC";
	        break;
	    case 'last_modified':
	        $order = 'last_modified';
    		$query = "SELECT r.*,d.title,d.text,d.last_modified FROM ".$db->prefix('realty')
    		.' r LEFT JOIN '.$db->prefix('realty_detail').' d ON r.property_id = d.property_id ';
    		$query .= " ORDER BY ".$order." DESC, updated DESC";
	        break;
	    case 'updated':
	    default:
	        $order = 'updated';
	    	$query = "SELECT r.*,d.text FROM ".$db->prefix('realty')
	    	.' r LEFT JOIN '.$db->prefix('realty_detail').' d ON r.property_id = d.property_id ';
	    	$query .= " ORDER BY ".$order." DESC";
	        break;
    }
    //echo $query; die;
    if (!$result = $db->query($query,$options[0],0)) {
        return false;
    }
    if ( $options[1] != 0 ) {
        $block['full_view'] = true;
    } else {
        $block['full_view'] = false;
    }
    $layout_desc = explode("|",_RE_LAYOUTDESC);
    while ($row = $db->fetchArray($result)) {
    	$row['options'] = $options[2];
     	$googlemap = $row['prefecture'].$row['county'].$row['township'].$row['address1'];
     	$row['googlemap'] = urlencode(mb_convert_encoding($googlemap,"UTF-8","EUC-JP"));
    	$row['constructed_year'] = intval($row['constructed_date']/100);
    	$row['constructed_month'] = $row['constructed_date'] - $row['constructed_year']*100;
    	$row['text'] = strip_tags($row['text']);
    	$ret = preg_match( "/\<img ([^\>]+)\>/i" , $row['text'] , $match);
    	if ( isset($match[0]) ){
    		$img = $match[0];
    	}else{
     		$row['icon'] = "condo_" . $row['number_of_rooms'] . $layout_desc[$row['room_layout_type']].".png";
    		$img = "<img src=\"" . XOOPS_URL . "/modules/realty/images/" . $row['icon'] . "\" alt=\"\" />";
       	}
    	$row['price_jp'] = (int)$row['price'] / 10000; 
    	$row['images'] = $img;
		$pattern='/<img .*?src="(.*?)".*?>/i';
    	//$row['dtext'] = preg_replace($pattern,"",$row['text']);
    	$row['dtext'] = mb_strcut(strip_tags($row['text']),0,140);
    	if(!isset($row['title'])) $row['title']=$googlemap;
    	if(!isset($row['last_modified'])) $row['last_modified']=$row['updated'];
    	if(!isset($row['dtext'])) $row['dtext'] = $row['remarks1'] . $row['remarks2'];
    	$block['recents'][] = $row;
    }
    return $block;
}
function b_realty_edit( $options )
{
    $inputtag = "<input type='text' name='options[0]' value='".$options[0]."' />";
    $form = sprintf(_MB_REALTY_DISPLAY,$inputtag);
    $form .= "<br />"._MB_REALTY_DISPLAYF."&nbsp;<input type='radio' name='options[1]' value='1'";
    if ( $options[1] == 1 ) {
        $form .= " checked='checked'";
    }
    $form .= " />&nbsp;"._YES."<input type='radio' name='options[1]' value='0'";
    if ( $options[1] == 0 ) {
        $form .= " checked='checked'";
    }
    $form .= " />&nbsp;"._NO;
    $form .= '<input type="hidden" name="options[2]" value="'.$options[2].'">';
    return $form;
}


?>
