<?php
// $Id: realty_sale.php,v 1.91 2009/01/05 16:43:54 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS Cube Realty - Realty Management System               //
//                    Copyright (c) 2010 Bluemoon inc.                       //
//                       <http://www.bluemooninc.jp/>                        //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;
$mydirname = basename( dirname( dirname( __FILE__ ) ) ) ;
if( ! preg_match( '/^(\D+)(\d*)$/' , $mydirname , $regs ) ) echo ( "invalid dirname: " . htmlspecialchars( $mydirname ) ) ;

include_once( XOOPS_ROOT_PATH . "/modules/$mydirname/include/mb_functions.php");


/*
 * Search block
 */
function realty_search( ){
	$search_typeid = isset($_GET['search_typeid']) ? intval($_GET['search_typeid']) : NULL;
	$search_railline = isset($_GET['search_railline']) ? htmlspecialchars($_GET['search_railline'], ENT_QUOTES) : NULL;
	$search_station_from = isset($_GET['search_station_from']) ? htmlspecialchars($_GET['search_station_from'], ENT_QUOTES) : NULL;
	$search_station_to = isset($_GET['search_station_to']) ? htmlspecialchars($_GET['search_station_to'], ENT_QUOTES) : NULL;
	$search_price_low = isset($_GET['search_price_low']) ? intval($_GET['search_price_low']) : NULL;
	$search_price_high = isset($_GET['search_price_high']) ? intval($_GET['search_price_high']) : NULL;
	$search_area_building = isset($_GET['search_area_building']) ? intval($_GET['search_area_building']) : NULL;
	$search_area_land = isset($_GET['search_area_land']) ? intval($_GET['search_area_land']) : NULL;
	$search_yearperiod = isset($_GET['search_yearperiod']) ? intval($_GET['search_yearperiod']) : NULL;
	$search_walkto = isset($_GET['search_walkto']) ? intval($_GET['search_walkto']) : NULL;
	$search_address = isset($_GET['search_address']) ? htmlspecialchars($_GET['search_address'], ENT_QUOTES) : NULL;
	$search_order = isset($_GET['search_order']) ? intval($_GET['search_order']) : NULL;
	$search_address = convert_mb_url($search_address); 
	$block['search_typeid'    ]=$search_typeid;
	$block['search_railline' ]=$search_railline;
	$block['search_station_from' ]=$search_station_from;
	$block['search_station_to' ]=$search_station_to;
	$block['search_price_low' ]=$search_price_low;
	$block['search_price_high']=$search_price_high;
	$block['search_area_building']=$search_area_building;
	$block['search_area_land' ]=$search_area_land;
	$block['search_yearperiod']=$search_yearperiod;
	$block['search_walkto'    ]=$search_walkto;
	$block['search_address' ]=$search_address;
	$block['search_order'     ]=$search_order;	
	return $block;
}
/*
 * Sale Rent switch
 */
function realty_switch(){
	global $_SESSION;
	if(!isset($_SESSION['realty_switch'])) $_SESSION['realty_switch']=0; 
    $block['switch'] = $_SESSION['realty_switch'];
    //echo $_SESSION['realty_switch']; die;
    return $block;
}
/*
 * Count block
 */
function realty_info($options){
	global $xoopsUser,$xoopsModuleConfig;
    $db =& Database::getInstance();
    $myts =& MyTextSanitizer::getInstance();
    $block = array();

	$data_tblname = $_SESSION['realty_switch']==0 ? "realty_sale" : "realty_rent" ;
    $query = "SELECT COUNT(*) FROM ".$db->prefix($data_tblname);
    list($total) = $db->fetchRow($db->query($query));
    $query = "SELECT COUNT(*) FROM ".$db->prefix($data_tblname)." WHERE updated>=NOW()-interval ". $options[0] . " day";
    list($newentry) = $db->fetchRow($db->query($query));
    $query = "SELECT last_modified FROM ".$db->prefix('realty_detail')." ORDER BY last_modified DESC LIMIT 1";
    list($last_modified) = $db->fetchRow($db->query($query));
    if ( $options[1] != 0 ) {
        $block['full_view'] = true;
    } else {
        $block['full_view'] = false;
    }
    $block['total'] = $total;
    $block['newentry'] = $newentry;
    $block['last_modified'] = $last_modified;
    return $block;
}
function option_info( $options ){
    $inputtag = "<input type='text' name='options[0]' value='".$options[0]."' />";
    $form = sprintf(_MB_REALTY_DISPDAYS,$inputtag);
    $form .= "<br />"._MB_REALTY_DISPLAYF."&nbsp;<input type='radio' name='options[1]' value='1'";
    if ( $options[1] == 1 ) {
        $form .= " checked='checked'";
    }
    $form .= " />&nbsp;"._YES."<input type='radio' name='options[1]' value='0'";
    if ( $options[1] == 0 ) {
        $form .= " checked='checked'";
    }
    $form .= " />&nbsp;"._NO;
    return $form;
}
/*
 * Recently upadte, New Built, Special recommends block
 */
function getImageURL( $text ){
	$ret = null;
	$iResults = preg_match_all('/<img .*?src="(.*?)".*?>/i', $text, $matches);
	if (is_array($matches) && isset($matches[1][0]))	$ret = $matches[1][0];
	return $ret;
}
function realty_show($options){
	global $xoopsUser,$xoopsModuleConfig;
    $db =& Database::getInstance();
    $myts =& MyTextSanitizer::getInstance();
    $block = array();
	$detailOnly = 0;
    switch($options[1]) {
	case 2:
		$wherestr[] = " updated>=NOW()-interval ". $xoopsModuleConfig['new_arrival_days'] . " day "; 
		break;
	case 3:
		$wherestr = " constructed_date >= " . (date("Y")-1)*100 + date("m") . " ";
		break;
	case 4:
		$wherestr = " property_id=0 ";
		break;
    }
	$data_tblname = $_SESSION['realty_switch']==0 ? "realty_sale" : "realty_rent" ;
  	$wherestr = strlen($options[1])>1 ? "WHERE " . $options[1] : ""; 
    switch($options[2]) {
	    case 'prompt_report':
	    	$detailOnly = 1;
	        $order = 'last_modified';
    		$query = "SELECT * FROM ".$db->prefix('realty_detail');
    		$query .= " WHERE realty_switch='" . $_SESSION['realty_switch'] . "' AND property_id='0' ORDER BY ".$order." DESC";
    		$listno = 4;
	        break;
    	case 'recommends':
	        $order = 'last_modified';
    		$query = "SELECT r.*,d.title,d.text,d.last_modified FROM ".$db->prefix($data_tblname)
    		.' r LEFT JOIN '.$db->prefix('realty_detail').' d ON r.property_id = d.property_id ';
    		$query .= " WHERE realty_switch='" . $_SESSION['realty_switch'] . "' AND recommends='1' ORDER BY ".$order." DESC, updated DESC";
    		$listno = 1;
	        break;
	    case 'last_modified':
	        $order = 'last_modified';
    		$query = "SELECT r.*,d.title,d.text,d.last_modified FROM ".$db->prefix($data_tblname)
    		.' r LEFT JOIN '.$db->prefix('realty_detail').' d ON r.property_id = d.property_id ';
    		$query .= $wherestr . "ORDER BY ".$order." DESC, updated DESC";
	        break;
	    case 'updated':
	    default:
	        $order = 'updated';
	    	$query = "SELECT r.*,d.text FROM ".$db->prefix($data_tblname)
	    	.' r LEFT JOIN '.$db->prefix('realty_detail').' d ON r.property_id = d.property_id ';
	    	$query .= $wherestr . " ORDER BY ".$order." DESC";
    		$listno = $options[1];
	        break;
    }
    //if ($wherestr!=""){ echo $query.$wherestr; die; }
    if (!$result = $db->query($query,$options[0],0)) {
        return false;
    }
    $layout_type = explode("|",_MB_LAYOUTDESC);
    while ($row = $db->fetchArray($result)) {
    	$row['options'] = $options[2];
    	if ($detailOnly==1){
     		$googlemap = $row['address'];
 		}else{
     		$googlemap = $row['prefecture'].$row['county'].$row['township'].$row['address1'];
	    	$row['constructed_year'] = intval($row['constructed_date']/100);
    		$row['constructed_month'] = $row['constructed_date'] - $row['constructed_year']*100;
    		if ($_SESSION['realty_switch']==0)
	       		$row['price_jp'] = (int)$row['price'] / 10000;
	       	else
	       		$row['price_jp'] = $row['price'];
	       	//if ( $row['number_of_rooms'] && $row['room_layout_type'])
     		$row['layout_desc'] = $row['number_of_rooms'] . strtolower($layout_type[$row['room_layout_type']]);
     		if ( $row['twf_station'] )
     			$row['stationto_desc'] = _MB_WALKTO . $row['twf_station'] . _MB_MIN;
	       	if(!isset($row['dtext'])) $row['dtext'] = $row['remarks1'] . $row['remarks2'];
     		if ($row['twf_station']) $row['transit'] = _RE_WALKTO . $row['twf_station'] . _RE_MIN;
     		if ($row['tbf_station']) $row['transit'] = $row['busline_name'] . $row['busstop_name'] . _RE_WALKTO . $row['twf_bustop'] . _RE_MIN;
 		}
     	$row['googlemap'] = urlencode(mb_convert_encoding($googlemap,"UTF-8","EUC-JP"));
    	$row['imageURL'] = getImageURL($row['text']);
    	if ( !isset($row['imageURL']) && $detailOnly==0 ){
    		switch($row['type_id']){
    			case 1:	
     				$row['icon'] = "land.png";
    				$row['imageURL'] = XOOPS_URL . "/modules/realty/images/" . $row['icon'];
    				break;
    			case 2:	
     				$row['icon'] = "house.png";
    				$row['imageURL'] = XOOPS_URL . "/modules/realty/images/" . $row['icon'];
    				$row['imageURL2'] = XOOPS_URL . "/modules/realty/images/" . $row['layout_desc'] . ".png";
    				break;
    			case 3:	
     				$row['icon'] = "condo.png";
    				$row['imageURL'] = XOOPS_URL . "/modules/realty/images/" . $row['icon'];
    				$row['imageURL2'] = XOOPS_URL . "/modules/realty/images/" . $row['layout_desc'] . ".png";
    				break;
    			case 4:	
     				$row['icon'] = "investment.png";
    				$row['imageURL'] = XOOPS_URL . "/modules/realty/images/" . $row['icon'];
    				break;
    		}
    	}
    	if(!isset($row['title'])) $row['title']=$googlemap;
    	if(!isset($row['last_modified'])) $row['last_modified']=$row['updated'];
    	$row['text'] = strip_tags($row['text']);
    	$row['dtext'] = mb_strcut(strip_tags($row['text']),0,140);
    	$block['recents'][] = $row;
    }
    $block['options'] = $options[2];
    $block['listno'] = $listno;
    return $block;
}
function option_listup( $options )
{
    $inputtag = "<input type='text' name='options[0]' value='".$options[0]."' />";
    $form = sprintf(_MB_REALTY_DISPLAY,$inputtag);
    $form .= "<br />".sprintf(_MB_REALTY_LISTNO,"<input type='text' name='options[1]' value='".$options[1]."' />");
    $form .= '<input type="hidden" name="options[2]" value="'.$options[2].'">';
    return $form;
}


?>
