<?php
// $Id: restore.php,v 1.1 2005/08/08 07:02:54 yoshis Exp $
//  ------------------------------------------------------------------------ //
//             BackPack - Bluemoon Backup/Restore Module for XOOPS           //
//              Copyright (c) 2005 Yoshi Sakai / Bluemoon inc.               //
//                       <http://www.bluemooninc.biz/>                       //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
include '../../../include/cp_header.php';

xoops_cp_header();

//require('../include/zip.lib.php');
//require('../include/defines.lib.php');
//require('../include/read_dump.lib.php');
// Include backup functions
//include("backup.ini.php");
include("../class/model_import.class.php");
include("csv_header_ujis.php");

$mode = '' ;
$action = '' ;
$filename = $filename_rent = '' ;
$restore_data = '' ;
$replace_url =  '';
// Make sure we pick up variables passed via URL
if( isset( $_GET[ 'mode' ] ) ) $mode = htmlspecialchars ( $_GET[ 'mode' ], ENT_QUOTES );
if( isset( $_GET[ 'action' ] ) ) $action = htmlspecialchars ( $_GET[ 'action' ], ENT_QUOTES );
if( isset( $_GET[ 'type' ] ) ) $type = htmlspecialchars ( $_GET[ 'type' ], ENT_QUOTES );
if( isset( $_GET[ 'filename' ] ) ) $filename = htmlspecialchars ( $_GET[ 'filename' ], ENT_QUOTES );
if( isset( $_GET[ 'filename_rent' ] ) ) $filename_rent = htmlspecialchars ( $_GET[ 'filename_rent' ], ENT_QUOTES );
if( isset( $_GET[ 'restore_data' ] ) ) $restore_data = htmlspecialchars ( $_GET[ 'restore_data' ], ENT_QUOTES );
if( isset( $_POST['replace_url'] ) ) $replace_url =  htmlspecialchars ( $_POST['replace_url'], ENT_QUOTES );
if( isset( $_POST['type'] ) ) $type = htmlspecialchars ( $_POST['type'], ENT_QUOTES );

$icsv = new importCSV(NULL);
if ($icsv->err_msg) echo "<font color='red'>" . $icsv->err_msg ."</font>";

// Display Admin Menu Tag
include_once './adminmenu.php';

// Handle URL actions
switch ($mode) {
	case "import": {
		@set_time_limit(TIME_LIMIT);
		echo "<b>Restore Complete</B><p>";
		echo "The Restore is complete. Any errors or messages encountered are shown below.";
		echo "<p />";
		if ($type=='sale'){
			$icsv->import_data($icsv->backup_dir.$filename, $xoopsDB->prefix("realty_sale"), "property_id", $header_converter);
			unlink($icsv->backup_dir.$filename);
		}else{
			$icsv->import_data($icsv->backup_dir.$filename, $xoopsDB->prefix("realty_rent"), "property_id", $header_converter_rent);
			unlink($icsv->backup_dir.$filename);
		}
		break;
	}
	case "upload": {
		echo "<table cellspacing=\"0\" cellpadding=\"3\">\n";
		if ($action == "backup") {
			echo "<tr><td class=\"title\">Backup MySQL Data</td></tr>\n";
			echo "<tr><td class=\"main_left\"><p><b>Select database to backup from</b>";
		}
		if ($action == "restore") {
			$fnm = $type=='sale' ? 'filename' : 'filename_rent';
			$upload       = $_FILES[$fnm];
			$upload_tmp   = $_FILES[$fnm]['tmp_name'];	// Temp File name
			$upload_name  = $_FILES[$fnm]['name'];		// Local File Name
			$upload_size  = $_FILES[$fnm]['size'];		// Size
			$upload_type  = $_FILES[$fnm]['type'];		// Type
			$upfile_error = $_FILES[$fnm]['error'];		//upload file error no
		    if ( $upfile_error > 0 ){
		    	switch ($upfile_error){
		    		case UPLOAD_ERR_INI_SIZE: echo "Over upload_max_filesize on php.ini"; break;
		    		case UPLOAD_ERR_FORM_SIZE: echo "Over MAX_FILE_SIZE at form"; break;
		    		case UPLOAD_ERR_PARTIAL: echo "An error occured while trying to recieve the file. Please try again."; break;
		    		case UPLOAD_ERR_NO_FILE: echo "No Upload File."; break;
					default: echo "Unknown Error - ".$upfile_error; print_r($_FILES); break;
				}
		    } 
			echo "<tr><td class=\"title\">"._AM_UPLOADED."</td></tr>\n";
			// Upload file
			$ret_val = move_uploaded_file($upload_tmp, $icsv->backup_dir.$upload_name);
			if (!$ret_val) {
				echo "<br /><br />Could not upload file.\n";
				echo "Check upload_max_filesize, post_max_size, memory_limit parameters in php.ini";
				echo "</p></td></tr>\n";
				echo "</table>\n";
				break;
			}
			echo "<tr><td class=\"main_left\"><p><b>" . $icsv->backup_dir . $upload_name . "</b>";
			echo "<form method=\"post\" action=\"import.php?mode=import&amp;type=$type&amp;filename=$upload_name\">\n";
		}
		echo "<input type=\"submit\" value=\""._AM_IMPORT."\">\n";
		echo "</form>\n";
		echo "</p></td></tr>\n";
		echo "</table>\n";
		break;
	}
	default: {
		if (!$filesize = ini_get('upload_max_filesize')) {
			$filesize = "5M";
		}
		$max_upload_size = $icsv->get_real_size($filesize);
		if ($postsize = ini_get('post_max_size')) {
			$postsize = $icsv->get_real_size($postsize);
			if ($postsize < $max_upload_size) {
				$max_upload_size = $postsize;
			}
		}
		unset($filesize);
		unset($postsize);
		$MaximumUploadSize = $icsv->PMA_displayMaximumUploadSize($max_upload_size);
		/*
		** for file upload
		*/
		$title = $type=='sale' ? _AM_REALTY_IMPORT_CSV : _AM_REALTY_IMPORT_RENT_CSV;
		echo "<table class='outer' width=100%><tr><td class=\"head\" colspan=2>".$title."</td></tr>\n";
		echo "<tr><td class='odd' width='30%'><b>"._AM_SELECT_CSV."</b></td>";
		echo "<td>";
		if ($type=='sale'){
			echo "<form method=\"post\" enctype=\"multipart/form-data\" action=\"import.php?mode=upload&action=restore&type=sale\">";
			echo "<input type='file' name='filename'>".$MaximumUploadSize."&nbsp;<input type=\"submit\" value=\""._SUBMIT."\" />";
		}else{
			echo "<form method=\"post\" enctype=\"multipart/form-data\" action=\"import.php?mode=upload&action=restore&type=rent\">";
			echo "<input type='file' name='filename_rent'>".$MaximumUploadSize."&nbsp;<input type=\"submit\" value=\""._SUBMIT."\" />";
		}
		echo "<INPUT TYPE='hidden' NAME='MAX_FILE_SIZE' VALUE='$max_upload_size'></form>";
		echo "</td></tr></table><p />";
	}
}
xoops_cp_footer();
?>