#include <windows.h>

/*
scankey.c
catch almost every keydown event and prints
VKey code / OEM key code / Ext flag

Implemented as to catch PrintScreen, but noticed that it's useless;)
Also, mouse button handling makes no sense.
*/

//#define IDH_PRTSCR 1001

LRESULT CALLBACK WndProc(HWND hwnd , UINT msg , WPARAM wp , LPARAM lp) {
	HDC hdc;
	TCHAR tcStr[64];

	switch (msg) {
//	case WM_CREATE:
//		RegisterHotKey(hwnd, IDH_PRTSCR, 0, VK_SNAPSHOT);
//		return 0;
	case WM_DESTROY:
//		UnregisterHotKey(hwnd, IDH_PRTSCR);
		PostQuitMessage(0);
		return 0;
//	case WM_HOTKEY:
//	case WM_LBUTTONDOWN:
//	case WM_MBUTTONDOWN:
//	case WM_RBUTTONDOWN:
	case WM_SYSKEYDOWN:
	case WM_KEYDOWN:
		wsprintf(tcStr, "key pressed: %02XH / %02XH / %d",
				 wp, lp >> 16 & 0xff, lp >> 24 & 0x1);
		hdc = GetDC(hwnd);
		SelectObject(hdc, GetStockObject(WHITE_PEN));
		Rectangle(hdc, 0, 0, 220, 60);
		TextOut(hdc, 10, 8, tcStr, lstrlen(tcStr));
		ReleaseDC(hwnd, hdc);
		return 0;
	}
	return DefWindowProc(hwnd, msg, wp, lp);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
				   LPSTR lpCmdLine, int nCmdShow ) {
	HWND hwnd;
	MSG msg;
	WNDCLASS winc;

	winc.style			= CS_HREDRAW | CS_VREDRAW;
	winc.lpfnWndProc	= WndProc;
	winc.cbClsExtra		= winc.cbWndExtra = 0;
	winc.hInstance		= hInstance;
	winc.hIcon			= LoadIcon(NULL, IDI_WINLOGO);
	winc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	winc.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	winc.lpszMenuName	= NULL;
	winc.lpszClassName	= TEXT("scankey");

	if (!RegisterClass(&winc)) return -1;

	hwnd = CreateWindow(
			TEXT("scankey"), TEXT("press (a) key(s) to scan"),
			WS_OVERLAPPEDWINDOW | WS_VISIBLE,
			CW_USEDEFAULT, CW_USEDEFAULT,
			220, 60, NULL, NULL, hInstance, NULL
	);

	if (hwnd == NULL) return -1;

	while(GetMessage(&msg, NULL, 0, 0))
		DispatchMessage(&msg);

	return msg.wParam;
}
