# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

include RDGC::Timer

describe RDGC::Timer::MonsterPopTimer, "will call dungeon's #create_monster at random" do

  before do
    @master = Object.new

    class << @master

      def add_monster
        @pop_count ||= 0
        @pop_count += 1
      end

      def pop_count
        @pop_count ||= 0
        @pop_count
      end

      def pop_count_reset
        @pop_count = 0
      end

      def disable?
        @disable
      end

      def disable
        @disable = true
      end
    end
  end

  it "create timer with cycle term and master" do
    timer = MonsterPopTimer.create(10, @master)
    timer.should be_an_instance_of(MonsterPopTimer)
    timer.cycle_type?.should be_true
    timer.limit_type?.should be_false

    timer.update(5)
    timer.action_ok?.should be_false
    timer.action.should be_false
    @master.pop_count.should == 0

    timer.update(5)
    timer.action_ok?.should be_true
    timer.action.should == :monster_pop
    @master.pop_count.should == 1
    @master.pop_count_reset
    @master.pop_count.should == 0

    timer.update_ratio = 2.0
    timer.update(5)
    timer.action_ok?.should be_true
    timer.action.should == :monster_pop
    @master.pop_count.should == 1
  end

  it "not create timer if illegal params" do
    timer1 = MonsterPopTimer.create(0, @master)
    timer1.should be_nil

    timer2 = MonsterPopTimer.create(100, nil)
    timer2.should be_nil
  end

  it "#disable? check master's status" do
    timer = MonsterPopTimer.create(10, @master)
    timer.should be_an_instance_of(MonsterPopTimer)
    @master.disable?.should be_false
    timer.disable?.should be_false

    @master.disable
    @master.disable?.should be_true
    timer.disable?.should be_true
  end

end
