# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

include RDGC::Timer

describe RDGC::Timer::CallbackTimer, "is timer, it callback to target's method" do

  class CallbackTimerTest

    def test
      @test
    end

    def call_test(str)
      @test = str
      :seted
    end

    def test_reset
      @test = nil
    end

    def disable
      @disable = true
    end

    def disable?
      @disable
    end

  end

  before do
    @tester = CallbackTimerTest.new

    @timer = CallbackTimer.new
    @timer.target = @tester
    @timer.call_method = :call_test
    @timer.args = "call!!"
  end

  it "#action check arrival, do_action, and reset_cycle" do
    @tester.test.should be_nil

    @timer.cycle = 5
    @timer.limit = 11
    @timer.update_ratio = 0.5

    @timer.update(10)
    @timer.action_ok?.should be_true
    @timer.action.should == :seted
    @tester.test.should == "call!!"
    @timer.cycle_time.should == 0.0
    @timer.pass_time.should == 5.0
    @timer.finish?.should be_false

    @tester.test_reset
    @timer.update(10)
    @timer.action_ok?.should be_true
    @timer.action == :seted
    @tester.test.should == "call!!"
    @timer.cycle_time.should == 0.0
    @timer.pass_time.should == 10.0
    @timer.finish?.should be_false

    @tester.test_reset
    @timer.update(2)
    @timer.action_ok?.should be_false
    @timer.action.should be_nil
    @tester.test.should be_nil
    @timer.cycle_time.should == 1.0
    @timer.pass_time.should == 11.0
    @timer.finish?.should be_true
  end

  it "#disable? check target's status" do
    @tester.disable?.should be_false
    @timer.disable?.should be_false

    @tester.disable
    @tester.disable?.should be_true
    @timer.disable?.should be_true
  end

  it "return fix result if set result" do
    @timer.result = :fix

    @timer.cycle = 5
    @timer.update(5)
    @timer.action_ok?.should be_true
    @timer.action.should == :fix
  end

end
