# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')
require File.expand_path(File.dirname(__FILE__) + '/pink_mini_status')

include RDGC::Monster

class PinkMini < Monster::Base
  include ActiveChaseType
  status_type PinkMiniStatus
  monster_name_is "(･ω･)"
end

describe RDGC::Monster::Base, "is base of monsters" do

  it "set monster's name" do
    PinkMini.set_monster_name("pori-n")
    PinkMini.monster_name.should == "pori-n"
    PinkMini.monster_name_is("ぽりーん")
    PinkMini.monster_name.should == "ぽりーん"
    PinkMini.monster_name = "(･ω･)"
    PinkMini.monster_name.should == "(･ω･)"
  end

  it "create will create monster, and init" do
    100.times do
      mons = PinkMini.create(10)

      mons.should be_an_kind_of(ActiveChaseType)
      mons.status_type.should ==  PinkMiniStatus
      mons.monster_name == "(･ω･)"

      mons.lv.should == 10
      mons.str.should >= 3
      mons.str.should <= 4
      mons.agi.should >= 3
      mons.agi.should <= 4
      mons.vit.should >= 3
      mons.vit.should <= 4
      mons.int.should >= 1
      mons.int.should <= 2
      mons.dex.should >= 3
      mons.dex.should <= 4
      mons.luk.should >= 6
      mons.luk.should <= 9
      mons.max_hp.should >= 24
      mons.max_hp.should <= 36
      mons.max_sp.should >= 1
      mons.max_sp.should <= 2
      mons.view_range.should == 5
    end
  end

end
