# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')
require File.expand_path(File.dirname(__FILE__) + '/pink_mini_status')

include RDGC::Monster

describe RDGC::Monster::MonsterStatus, "is module of monster's status" do

  it "#init will create status, and can't call again" do
    100.times do
      mons = create(10)

      mons.lv.should == 10
      mons.str.should >= 3
      mons.str.should <= 4
      mons.agi.should >= 3
      mons.agi.should <= 4
      mons.vit.should >= 3
      mons.vit.should <= 4
      mons.int.should >= 1
      mons.int.should <= 2
      mons.dex.should >= 3
      mons.dex.should <= 4
      mons.luk.should >= 6
      mons.luk.should <= 9
      mons.max_hp.should >= 24
      mons.max_hp.should <= 36
      mons.max_sp.should >= 1
      mons.max_sp.should <= 2
      mons.view_range.should == 5

      mons.timer.cycle.should >= 196
      mons.timer.cycle.should <= 197
      mons.timer.update_ratio.should == 1.0

      mons.init(PinkMiniStatus, 5)
      mons.lv.should == 10
    end
  end

  it "#exp provides exp value of it dead, at least 1" do
    mons1 = create(10)
    mons1.exp.should == 5

    mons2 = create(1)
    mons2.exp.should == 1
  end

  def create(lv)
    mons = Object.new
    mons.extend(MonsterStatus)
    mons.init(PinkMiniStatus, lv)
    mons
  end

end
