# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

class SomeMonsterStatus < RDGC::Monster::MonsterStatusType
end

class PinkMiniStatus < RDGC::Monster::MonsterStatusType
  str_base_is 2.0
  agi_base_is 1.0
  vit_base_is 3.0
  int_base_is 1.0
  dex_base_is 1.0
  luk_base_is 4.0

  hp_base_is 10
  sp_base_is 1

  str_up_ratio_is 0.2
  agi_up_ratio_is 0.3
  vit_up_ratio_is 0.1
  int_up_ratio_is 0.1
  dex_up_ratio_is 0.3
  luk_up_ratio_is 0.4

  hp_up_ratio_is 2.0
  sp_up_ratio_is 0.1

  exp_ratio_is 0.5

  view_range_is 5
end

describe RDGC::Monster::MonsterStatusType, "is calc base of monster's status" do

  it "set each params" do
    SomeMonsterStatus.exp_ratio.should == 1.0
    SomeMonsterStatus.set_exp_ratio(1.5)
    SomeMonsterStatus.exp_ratio.should == 1.5
    SomeMonsterStatus.exp_ratio_is(5.0)
    SomeMonsterStatus.exp_ratio.should == 5.0
    SomeMonsterStatus.exp_ratio = 12.3
    SomeMonsterStatus.exp_ratio.should == 12.3
  end

  it "create_status_from_lv will provides status value for lv at random" do
    100.times do
      str = PinkMiniStatus.create_status_from_lv(:str, 10)
      str.should >= 3.4
      str.should <= 4.6

      agi = PinkMiniStatus.create_status_from_lv(:agi, 9)
      agi.should >= 2.8
      agi.should <= 4.6

      vit = PinkMiniStatus.create_status_from_lv(:vit, 8)
      vit.should >= 3.5
      vit.should <= 4.1

      int = PinkMiniStatus.create_status_from_lv(:int, 7)
      int.should >= 1.4
      int.should <= 2.0

      dex = PinkMiniStatus.create_status_from_lv(:dex, 6)
      dex.should >= 2.2
      dex.should <= 3.4

      luk = PinkMiniStatus.create_status_from_lv(:luk, 5)
      luk.should >= 5.4
      luk.should <= 6.6

      hp = PinkMiniStatus.create_status_from_lv(:hp, 12)
      hp.should >= 26
      hp.should <= 42

      sp = PinkMiniStatus.create_status_from_lv(:sp, 15)
      sp.should >= 2.0
      sp.should <= 3.0
    end

  end

end
