# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')
require File.expand_path(File.dirname(__FILE__) + '/swordman')

include RDGC::Character

class TestPlayer < Player
  include BattleRoll
  attr_accessor :test_stat

  def self.tester_create(lv)
    pl = self.create(RDGC::Character::Swordman)
    lv.times{pl.lvup}
    pl.test_stat = "init"
    pl
  end

  def before_attack(d)
    stat_change("init", "#{test_name}:before_attack")
  end

  private

  def stat_change(b, a)
    @test_stat.should == b
    @test_stat = a
  end

end

class TestAttacker < TestPlayer

  def test_name
    "Attacker"
  end

  def judge_attack_result(d, rsl, val)
    stat_change("#{test_name}:before_attack", "#{test_name}:judge_attack_result")

    [:hit, :critical, :miss, :fumble].include?(rsl).should == true

    case rsl
    when :hit
      val.should > 0
      val.should >= (self.dex/5.0).ceil
    when :critical
      val.should > 0
      val.should >= self.dex
    when :miss, :fumble
      val.should == 0
    end

    val
  end

  def after_attack(d, rsl, val)
    stat_change("#{test_name}:judge_attack_result", "#{test_name}:after_attack")
  end

  def close_attack(d)
    stat_change("#{test_name}:after_attack", "#{test_name}:close_attack")
  end

end

class TestDefender < TestPlayer

  def test_name
    "Defender"
  end

  def after_attack(d, rsl, val)
    stat_change("#{test_name}:before_attack", "#{test_name}:after_attack")
  end

end

describe RDGC::Character::BattleRoll, "will handle battle result" do

  it "#attack_to execute each battle proccess" do

    100.times do
      attacker = TestAttacker.tester_create(9)
      defender = TestDefender.tester_create(5)
      defender.reduce_hp(defender.max_hp - 10)

      attacker.attack_to(defender)
      attacker.test_stat.should == "#{attacker.test_name}:close_attack"
      defender.test_stat.should == "#{defender.test_name}:after_attack"
      defender.disable?.should be_true if defender.hp <= 0
    end

  end

end
