# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

describe RDGC::Character::Base, "is movable articles with timer" do

  before(:all) do
    @board = Maker::DivideDungeonMaker.create(20, 20, :min_room_size => 99)
  end

  before do
    @chara = Character::Base.new

    @floor = Map::Floor.create_from_board(@board)
    @floor.add_article(@chara)

    @ememy = Character::Base.new
    @floor.add_article(@ememy)

    @art = Article::Base.new
    @floor.add_article(@art)
  end

  it "basic characteristic" do
    @chara.should be_a_kind_of(Article::Base)
    @chara.overlapable?.should be_false
    @chara.floor.should == @floor
  end

  it "move on floor" do
    @chara.set(1, 1)

    @chara.move(Map::Direction::SELF).should == :moved
    @chara.exist?(1, 1).should be_true

    @chara.move(Map::Direction::UPPER).should be_nil
    @chara.exist?(1, 0).should be_false
    @chara.exist?(1, 1).should be_true

    @chara.move(Map::Direction::RIGHT).should == :moved
    @chara.exist?(1, 1).should be_false
    @chara.exist?(2, 1).should be_true

    @chara.set(17, 17)

    @chara.move(Map::Direction::RIGHT).should be_nil
    @chara.exist?(18, 17).should be_false
    @chara.exist?(17, 17).should be_true

    @chara.move(Map::Direction::UPPER).should == :moved
    @chara.exist?(17, 17).should be_false
    @chara.exist?(17, 16).should be_true
  end

  it "collision with other non-overlapable articles" do
    @chara.set(10, 10)
    @ememy.set(9, 10)
    @ememy.enable?.should be_true

    @chara.move(Map::Direction::LEFT).should == :not_move
    @chara.exist?(10, 10).should be_true
    @ememy.exist?(9, 10).should be_true
    @ememy.enable?.should be_true

    class << @ememy

      def reaction_to(a)
        self.disable
      end

    end

    @chara.move(Map::Direction::LEFT).should == :not_move
    @chara.exist?(10, 10).should be_true
    @ememy.exist?(9, 10).should be_false
    @ememy.enable?.should be_false
  end

  it "return disabled if collision with other and disabled" do
    @chara.set(10, 10)
    @ememy.set(9, 10)
    @chara.enable?.should be_true

    class << @ememy

      def reaction_to(a)
        a.disable
      end

    end

    @chara.move(Map::Direction::LEFT).should == :disabled
    @chara.exist?(10, 10).should be_false
    @chara.exist?(9, 10).should be_false
    @chara.x.should == 10
    @chara.y.should == 10
    @chara.enable?.should be_false
  end

  it "overlap with overlapable articles" do
    @chara.set(12, 12)
    @art.set(12, 13)
    @art.enable?.should be_true

    @chara.move(Map::Direction::BOTTOM).should == :moved
    @chara.exist?(12, 12).should be_false
    @chara.exist?(12, 13).should be_true
    @art.exist?(12, 13).should be_true
    @art.enable?.should be_true
  end

  it "return disabled if overlap to other and disabled" do
    @chara.set(12, 12)
    @art.set(12, 13)
    @chara.enable?.should be_true
    @art.enable?.should be_true

    class << @art

      def reaction_to(a)
        self.disable
        a.disable
      end

    end

    @chara.move(Map::Direction::BOTTOM).should == :disabled
    @chara.exist?(12, 13).should be_false
    @chara.x.should == 12
    @chara.y.should == 13
    @chara.enable?.should be_false
    @art.enable?.should be_false
  end

end
