# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

include RDGC::Article

class TimeTestActor1 < Article::Base
  include Article::TimeControlled

  def act_cycle
    120
  end

  def act_ratio
    1.2
  end

  def action
    @called = true
  end

  def action_called?
    @called
  end

end

class TimeTestActor2 < TimeTestActor1

  def act_limit
    1200
  end

end

describe RDGC::Article::TimeControlled, "is action article at time" do

  it "#create_timer provides CallbackTimer's object, will callback #action" do
    act1 = TimeTestActor1.new
    act1.update_timer_status
    timer1 = act1.timer
    timer1.should be_an_instance_of(Timer::CallbackTimer)

    timer1.target.should == act1
    timer1.call_method.should == :action
    timer1.cycle.should == 120
    timer1.update_ratio.should == 1.2
    timer1.limit.should be_nil

    act2 = TimeTestActor2.new
    act2.update_timer_status
    timer2 = act2.timer
    timer2.should be_an_instance_of(Timer::CallbackTimer)

    timer2.target.should == act2
    timer2.call_method.should == :action
    timer2.cycle.should == 120
    timer2.update_ratio.should == 1.2
    timer2.limit.should == 1200
  end

  it "#next_count/#next_time/#update_time/#action_ok? transfer to timer it has" do
    act = TimeTestActor2.new
    act.update_timer_status

    act.next_count.should == 100
    act.next_time.should == 120
    act.action_ok?.should be_false

    act.update_time(10)
    act.next_count.should == 90
    act.next_time.should == 108
    act.action_ok?.should be_false

    act.update_time(90)
    act.next_count.should == 0
    #act.next_time.should == 0
    act.action_ok?.should be_true

    act.timer.action
    act.action_called?.should be_true

    act.update_time(900)
    act.timer.finish?.should be_true
  end

end
