# coding: UTF-8
module ROgue01
  module Scene
    class Main < ROgueScene
      include RDGC::Core::DungeonScene

      # override
      def render
        @drawer ||= BlockDrawer.new
        @drawer.draw(dungeon_master)
      end

      # override
      def init_dungeon_scene
        floor_number = params[:start_floor]

        pl = RDGC::Character::Player.create(ROgue01::Character::Swordman)
        pl.player_name = "あなた"
        pl.set_wep_atk(5.0)
        pl.set_arm_def(3.0)
        self.player = pl

        player_timers << RDGC::Timer::AutoHealingTimer. create(RDGC::Util::Config.act_max_count * 3, player)
      end

      # override
      def create_master
        case params[:game_mode]
        when :normal
          create_normal_master
        when :endless
          create_endless_master
        end
      end

      def create_normal_master
        if floor_number < ROGUE_MAX_FLOOR
          Master::NormalDungeonMaster.create(player, :floor_number => floor_number)
        else
          Master::NormalDungeonMaster.create(player,
          :floor_number => floor_number,
          :monster_density => 3.0,
          :monster_pop_time => (RDGC::Util::Config.act_max_count * 3)
          )
        end
      end

      def create_endless_master
        Master::EndlessDungeonMaster.create(player, :floor_number => floor_number)
      end

      def pre_judge
        if player.disable?
          to_gameover
          return :player_dead
        end

        if normal_mode? && dungeon_master.boss_dead?
          to_ending
          return :boss_dead
        end
      end

      # override
      def judge(rsl)
        # Player死亡
        if player.disable?
          RDGC::Message::MessageManager << "Press SPACE..."
          to_gameover
          return
        end

        add_turn_count if rsl.to_s.match(/^player_/)

        # BOSS死亡
        if normal_mode? && dungeon_master.boss_dead?
          RDGC::Message::MessageManager << %Q("熟しきったリンゴ"を手に入れた！)
          RDGC::Message::MessageManager << "Press SPACE..."
          to_ending
          return
        end

        if rsl == :player_step_down
          move_floor(floor_number + 1)
          RDGC::Message::MessageManager.add(:player_step_down,
          :player_name => player.name, :floor_number => floor_number)
        end
      end

      def add_turn_count
        @turn_count ||= 0
        @turn_count += 1
      end

      def turn_count
        @turn_count ||= 0
        @turn_count
      end

      def to_gameover
        return unless Input.keyPush?(K_SPACE)
        params[:start_floor] = floor_number if endless_mode?
        params[:use_turn] = turn_count if normal_mode?
        turn_to :gameover
      end

      def to_ending
        return unless Input.keyPush?(K_SPACE)
        params[:use_turn] = turn_count
        turn_to :ending1
      end

    end
  end
end
