# coding: UTF-8
module ROgue01
  module Master
    class PinkMazeDungeonMaster < RDGC::Core::DungeonMaster

      def create_floor_size
        range_rand(20, 40 + floor_number)
      end

      def select_visible_level
        return :normal if floor_number <= 1
        select_rand(:normal => 8, :blind => 1, :none => 1)
      end

      def create_normal_board
        width = create_floor_size
        height = create_floor_size
        level = select_visible_level

        b = RDGC::Maker::DivideDungeonMaker.create(width, height)
        b.set_blind_mode(level)

        if level == :normal && floor_number > 1
          dark_max = (b.rooms.size.to_f / 3.0).ceil
          dark_count = range_rand(0, dark_max)
          dark_count.times do
            b.rooms.choice.set_blind(:dark)
          end
        end

        b.fill_blind
        b
      end

      def create_normal_floor
        RDGC::Map::Floor.create_from_board(create_normal_board)
      end

      def prapare_articles_normal
        # スタート/ゴール地点選択
        start_block = floor.rooms.choice
        end_block = floor.rooms.reject{|b| b == start_block}.choice

        px, py = start_block.random_point
        sx, sy = end_block.random_point

        # 座標セット
        player.set(px, py)
        up_step = RDGC::Article::Step.create_up_step(px, py)
        down_step = RDGC::Article::Step.create_down_step(sx, sy)

        add_article(player)
        add_article(up_step)
        add_article(down_step)
      end

      def create_lv
        range_rand((floor_number * 0.5).ceil, (floor_number * 1.5 + player.lv * 0.5).ceil)
      end

      def create_mini
        Monster::PinkMini.create(create_lv)
      end

    end
  end
end
