# coding: UTF-8
module ROgue01
  module Master
    class NormalDungeonMaster < PinkMazeDungeonMaster

      def final_floor?
        floor_number >= ROGUE_MAX_FLOOR ? true : false
      end

      # override
      def create_floor
        final_floor? ? create_final_floor : create_normal_floor
      end

      # override
      def prapare_articles
        final_floor? ? prapare_articles_final : prapare_articles_normal
      end

      # override
      def prapare_articles_final
        # BOSS生成
        boss = Monster::PinkBig.create(floor_number * 3)
        boss.boss_flag = true
        @boss = boss

        # スタート/ゴール地点選択
        start_block = floor.rooms.choice
        end_block = floor.rooms.reject{|b| b == start_block}.choice

        px, py = start_block.random_point
        sx, sy = end_block.random_point

        # 座標セット
        player.set(px, py)
        boss.set(sx, sy)
        up_step = RDGC::Article::Step.create_up_step(px, py)

        add_article(player)
        add_article(up_step)
        add_article(boss)

        # 取り巻き追加
        10.times do
          mini = Monster::PinkMini.create(floor_number * 3)
          find = false
          10.times do
            mx, my = end_block.random_point
            next unless floor.articles_for(mx, my).empty?
            mini.set(mx, my)
            find = true
            break
          end
          add_article(mini) if find
        end
      end

      def create_final_floor
        RDGC::Map::Floor.create_from_board(create_final_board)
      end

      def create_final_board
        b = RDGC::Maker::DivideDungeonMaker.create(40, 40,
        :min_room_count => 3, :max_room_count => 4, :min_room_size => 6,
        :min_block_size => 10, :max_block_count => 5)
        b.set_blind_mode(:normal)
        b.fill_blind
        b
      end

      # override
      def create_monster
        create_mini
      end

      def has_boss?
        @boss ? true : false
      end

      def boss_dead?
        return false unless has_boss?
        @boss.disable?
      end

    end
  end
end
