# coding: UTF-8
module RDGC
  module Util
    class Config

      DEFAULT_CONFIG = {
        :min_room_size => 4,
        :act_max_count => 200,
        :monster_status_random_level => 3,
        :battle_roll_module => 'RDGC::Character::BattleRoll',
        :message_buffer_size => 10
      }

      class << self

        def set(hash)
          return if seted?

          hash = DEFAULT_CONFIG.merge(hash)
          @config_hash = hash
          @seted = true

          true
        end

        def get(key)
          @config_hash ||= DEFAULT_CONFIG
          @config_hash[key]
        end

        def seted?
          @seted ? true : false
        end

        def reset!
          @config_hash = DEFAULT_CONFIG
          @seted = false
          true
        end

        def min_room_size
          get(:min_room_size)
        end

        def min_block_size
          # デフォルトのblock最小値 = 最小部屋サイズ+上下空き2+接線通路分1
          min_room_size + 3
        end

        def act_max_count
          get(:act_max_count)
        end

        def monster_status_random_level
          get(:monster_status_random_level)
        end

        def battle_roll_module
          eval(get(:battle_roll_module))
        end

        def message_buffer_size
          get(:message_buffer_size)
        end

      end

    end
  end
end

